/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import javax.management.InvalidAttributeValueException;
import weblogic.application.ComponentMBeanFactory;
import weblogic.application.internal.ComponentMBeanHelper;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.utils.Debug;

public abstract class BaseComponentMBeanFactory {
    public boolean needsApplicationPathMunging() {
        return true;
    }

    protected void dumpCompMBeans(ApplicationMBean applicationMBean) {
        Debug.say((String)("** Dumping ComponentMBeans for app " + applicationMBean.getName()));
        ComponentMBean[] componentMBeanArray = applicationMBean.getComponents();
        if (componentMBeanArray == null) {
            componentMBeanArray = new ComponentMBean[]{};
        }
        Debug.say((String)("** App has " + componentMBeanArray.length + " ComponentMBeans"));
        for (int i = 0; i < componentMBeanArray.length; ++i) {
            Debug.say((String)("** Type is " + componentMBeanArray[i].getClass().getName() + " uri is " + componentMBeanArray[i].getURI()));
        }
    }

    protected String removeExtension(String string) {
        int n = string.lastIndexOf(".");
        return n == -1 ? string : string.substring(0, n);
    }

    protected final ComponentMBean findOrCreateComponentMBean(ComponentMBeanFactory.MBeanFactory mBeanFactory, ApplicationMBean applicationMBean, String string) {
        return this.findOrCreateComponentMBean(mBeanFactory, applicationMBean, string, string);
    }

    protected final ComponentMBean findOrCreateComponentMBean(ComponentMBeanFactory.MBeanFactory mBeanFactory, ApplicationMBean applicationMBean, String string, String string2) {
        try {
            ComponentMBean componentMBean = ComponentMBeanHelper.findComponentMBeanByName(applicationMBean, string, mBeanFactory.getComponentMBeanType());
            if (componentMBean != null) {
                return componentMBean;
            }
            componentMBean = mBeanFactory.newCompMBean(applicationMBean, string);
            componentMBean.setApplication(applicationMBean);
            componentMBean.setURI(string2);
            return componentMBean;
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)invalidAttributeValueException);
        }
    }

    protected String getCompatibilityName(String string, AppDeploymentMBean appDeploymentMBean) {
        String string2 = appDeploymentMBean.getCompatibilityName();
        return string2 == null ? string : string2;
    }
}

