/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.Deployment;
import weblogic.application.Module;
import weblogic.application.ModuleLocationInfo;
import weblogic.application.ModuleManager;
import weblogic.application.ModuleWrapper;
import weblogic.application.internal.ApplicationContextImpl;
import weblogic.application.internal.Flow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.StateChange;
import weblogic.application.utils.StateChangeException;
import weblogic.application.utils.StateMachineDriver;
import weblogic.deploy.container.DeploymentContext;
import weblogic.deploy.container.NonFatalDeploymentException;
import weblogic.j2ee.J2EELogger;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StringUtils;

abstract class BaseDeployment
implements Deployment {
    private final StateMachineDriver driver = new StateMachineDriver();
    String asString = null;
    protected final ApplicationContextImpl appCtx;
    private static final StateChange prepareStateChange = new StateChange(){

        public String toString() {
            return "prepare";
        }

        public void next(Object object) throws Exception {
            ((Flow)object).prepare();
        }

        public void previous(Object object) throws Exception {
            ((Flow)object).unprepare();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringUndeploymentError((Throwable)stateChangeException.getCause());
        }
    };
    private static final StateChange activateStateChange = new StateChange(){

        public String toString() {
            return "activate";
        }

        public void next(Object object) throws Exception {
            ((Flow)object).activate();
        }

        public void previous(Object object) throws Exception {
            ((Flow)object).deactivate();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringUndeploymentError((Throwable)stateChangeException.getCause());
        }
    };
    private static final StateChange removeStateChange = new StateChange(){

        public String toString() {
            return "remove";
        }

        public void next(Object object) throws Exception {
            throw new AssertionError((Object)"someone is transitioning up to remove!");
        }

        public void previous(Object object) throws Exception {
            ((Flow)object).remove();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringUndeploymentError((Throwable)stateChangeException.getCause());
        }
    };
    private static final StateChange adminStateChange = new StateChange(){

        public String toString() {
            return "admin";
        }

        public void next(Object object) throws Exception {
            ((Flow)object).adminToProduction();
        }

        public void previous(Object object) throws Exception {
            ((Flow)object).forceProductionToAdmin(new AdminModeCompletionBarrier(EarUtils.noopAdminModeCallback));
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringAdminModeErrro((Throwable)stateChangeException.getCause());
        }
    };

    public BaseDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        this.initString(appDeploymentMBean);
        this.appCtx = new ApplicationContextImpl(appDeploymentMBean, file);
    }

    public BaseDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        this.initString(systemResourceMBean);
        this.appCtx = new ApplicationContextImpl(systemResourceMBean, file);
    }

    private void initString(BasicDeploymentMBean basicDeploymentMBean) {
        this.asString = "[" + this.getClass().getName() + "] name: " + basicDeploymentMBean.getName() + " path: " + basicDeploymentMBean.getSourcePath();
    }

    public String toString() {
        return this.asString;
    }

    protected void throwAppException(Throwable throwable) throws DeploymentException {
        ErrorCollectionException errorCollectionException;
        if (throwable instanceof DeploymentException) {
            throw (DeploymentException)((Object)throwable);
        }
        if (throwable instanceof ErrorCollectionException && (errorCollectionException = (ErrorCollectionException)throwable).size() == 1) {
            this.throwAppException((Throwable)errorCollectionException.getErrors().next());
        }
        throw new DeploymentException(throwable);
    }

    protected abstract Flow[] getFlow();

    private ClassLoader pushLoader() {
        Thread thread2 = Thread.currentThread();
        ClassLoader classLoader = thread2.getContextClassLoader();
        thread2.setContextClassLoader((ClassLoader)this.appCtx.getAppClassLoader());
        return classLoader;
    }

    private void popLoader(ClassLoader classLoader) {
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    private void propagateDeploymentContext(DeploymentContext deploymentContext) {
        if (deploymentContext == null) {
            return;
        }
        this.appCtx.setProposedDomain(deploymentContext.getProposedDomain());
        this.appCtx.setDeploymentInitiator(deploymentContext.getInitiator());
        this.appCtx.setRequiresRestart(deploymentContext.requiresRestart());
        this.appCtx.setDeploymentOperation(deploymentContext.getDeploymentOperation());
        this.appCtx.setStaticDeploymentOperation(deploymentContext.isStaticDeploymentOperation());
        if (deploymentContext.isStaticDeploymentOperation()) {
            this.appCtx.setStoppedModules(deploymentContext.getStoppedModules());
        }
        ApplicationVersionUtils.setAdminModeAppCtxParam(this.appCtx, deploymentContext.isAdminModeTransition());
        ApplicationVersionUtils.setIgnoreSessionsAppCtxParam(this.appCtx, deploymentContext.isIgnoreSessionsEnabled());
        ApplicationVersionUtils.setRMIGracePeriodAppCtxParam(this.appCtx, deploymentContext.getRMIGracePeriodSecs());
    }

    private void resetDeploymentContext() {
        this.appCtx.setProposedDomain(null);
        this.appCtx.setDeploymentInitiator(null);
        this.appCtx.setDeploymentOperation(-1);
        ApplicationVersionUtils.unsetAdminModeAppCtxParam(this.appCtx);
        ApplicationVersionUtils.unsetIgnoreSessionsAppCtxParam(this.appCtx);
        ApplicationVersionUtils.unsetRMIGracePeriodAppCtxParam(this.appCtx);
    }

    private String[] getUpdatedResourceURIs(DeploymentContext deploymentContext) {
        String[] stringArray = new String[]{};
        if (deploymentContext != null && deploymentContext.getUpdatedResourceURIs() != null) {
            stringArray = EarUtils.toModuleIds(this.appCtx, deploymentContext.getUpdatedResourceURIs());
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("prepare " + this.appCtx.getApplicationId());
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.nextState(prepareStateChange, this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var5_4 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var5_3 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("activate " + this.appCtx.getApplicationId());
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.nextState(activateStateChange, this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var5_4 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var5_3 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("deactivate " + this.appCtx.getApplicationId());
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.previousState(activateStateChange, this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var5_4 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var5_3 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("unprepare " + this.appCtx.getApplicationId());
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.previousState(prepareStateChange, this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var5_4 = null;
                this.appCtx.clear();
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var5_3 = null;
            this.appCtx.clear();
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.appCtx.clear();
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("remove " + this.appCtx.getApplicationId());
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.previousState(removeStateChange, this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var5_4 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var5_3 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateRedeploy(DeploymentContext deploymentContext) throws DeploymentException {
        String[] stringArray = this.getUpdatedResourceURIs(deploymentContext);
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("validateRedeploy " + this.appCtx.getApplicationId() + " uris --> " + StringUtils.join((String[])stringArray, (String)","));
        }
        if (stringArray.length == 0) {
            return;
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.driver.nextState(new ValidateRedeployStateChange(deploymentContext), this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var6_5 = null;
                this.popLoader(classLoader);
                this.appCtx.setAdditionalModuleUris(Collections.EMPTY_MAP);
                this.appCtx.setProposedPartialRedeployDDs(null);
            }
            Object var6_4 = null;
            this.popLoader(classLoader);
            this.appCtx.setAdditionalModuleUris(Collections.EMPTY_MAP);
            this.appCtx.setProposedPartialRedeployDDs(null);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.popLoader(classLoader);
            this.appCtx.setAdditionalModuleUris(Collections.EMPTY_MAP);
            this.appCtx.setProposedPartialRedeployDDs(null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(DeploymentContext deploymentContext) throws DeploymentException {
        Object object;
        String[] stringArray = this.getUpdatedResourceURIs(deploymentContext);
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("start " + this.appCtx.getApplicationId() + " uris --> " + StringUtils.join((String[])stringArray, (String)","));
        }
        if (!this.appCtx.isRedeployOperation() && ((ModuleManager)(object = this.appCtx.getModuleManager())).validateModuleIds(stringArray)) {
            throw new NonFatalDeploymentException(J2EELogger.logModulesAlreadyRunningErrorLoggable((String)StringUtils.join((String[])((ModuleManager)object).getValidModuleIds(stringArray), (String)",")).getMessage());
        }
        object = this.getFlow();
        ClassLoader classLoader = this.pushLoader();
        if (this.appCtx.getPartialRedeployURIs() != null) {
            stringArray = this.appCtx.getPartialRedeployURIs();
        }
        this.appCtx.setPartialRedeployURIs(stringArray);
        try {
            this.propagateDeploymentContext(deploymentContext);
            Throwable throwable = null;
            for (int i = 0; i < ((Object)object).length; ++i) {
                object[i].start(stringArray);
            }
            if (throwable != null) {
                this.throwAppException(throwable);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (this.appCtx.getStartingModules() != null && this.appCtx.getStartingModules().length > 0) {
                this.appCtx.setStartingModules(new Module[0]);
            }
            this.appCtx.setPartialRedeployURIs(null);
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
        if (this.appCtx.getStartingModules() != null && this.appCtx.getStartingModules().length > 0) {
            this.appCtx.setStartingModules(new Module[0]);
        }
        this.appCtx.setPartialRedeployURIs(null);
        this.resetDeploymentContext();
        this.popLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(DeploymentContext deploymentContext) throws DeploymentException {
        ClassLoader classLoader;
        block12: {
            block13: {
                this.setModuleURItoModuleIdMap();
                String[] stringArray = this.getUpdatedResourceURIs(deploymentContext);
                if (EarUtils.isDebugOn()) {
                    EarUtils.debug("stop " + this.appCtx.getApplicationId() + " uris --> " + StringUtils.join((String[])stringArray, (String)","));
                }
                this.propagateDeploymentContext(deploymentContext);
                this.validateRedeploy(deploymentContext);
                Flow[] flowArray = this.getFlow();
                classLoader = this.pushLoader();
                try {
                    ErrorCollectionException errorCollectionException = null;
                    if (this.appCtx.getPartialRedeployURIs() != null) {
                        stringArray = this.appCtx.getPartialRedeployURIs();
                    }
                    for (int i = flowArray.length - 1; i >= 0; --i) {
                        try {
                            flowArray[i].stop(stringArray);
                            continue;
                        }
                        catch (Throwable throwable) {
                            if (errorCollectionException == null) {
                                errorCollectionException = new ErrorCollectionException();
                            }
                            errorCollectionException.addError(throwable);
                        }
                    }
                    if (errorCollectionException != null) {
                        this.throwAppException((Throwable)errorCollectionException);
                    }
                    Object var9_8 = null;
                    if (!this.appCtx.isStopOperation()) break block12;
                    if (this.appCtx.getStoppingModules() == null) break block13;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (this.appCtx.isStopOperation()) {
                        if (this.appCtx.getStoppingModules() != null && this.appCtx.getStoppingModules().length > 0) {
                            this.appCtx.setStoppingModules(new Module[0]);
                        }
                        this.appCtx.setPartialRedeployURIs(null);
                    }
                    this.resetDeploymentContext();
                    this.popLoader(classLoader);
                    throw throwable;
                }
                if (this.appCtx.getStoppingModules().length > 0) {
                    this.appCtx.setStoppingModules(new Module[0]);
                }
            }
            this.appCtx.setPartialRedeployURIs(null);
        }
        this.resetDeploymentContext();
        this.popLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        String[] stringArray = this.getUpdatedResourceURIs(deploymentContext);
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("prepareUpdate " + this.appCtx.getApplicationId() + " uris --> " + StringUtils.join((String[])stringArray, (String)","));
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.nextState(new PrepareUpdateStateChange(stringArray), this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var6_5 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var6_4 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        String[] stringArray = this.getUpdatedResourceURIs(deploymentContext);
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("activateUpdate " + this.appCtx.getApplicationId() + " uris --> " + StringUtils.join((String[])stringArray, (String)","));
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.nextState(new ActivateUpdateStateChange(stringArray), this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var6_5 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var6_4 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
        this.updateAppDeploymentBean(deploymentContext);
    }

    private void updateAppDeploymentBean(DeploymentContext deploymentContext) {
        if (deploymentContext != null && deploymentContext.getProposedDomain() != null) {
            AppDeploymentMBean appDeploymentMBean = deploymentContext.getProposedDomain().lookupAppDeployment(this.appCtx.getApplicationId());
            this.appCtx.setUpdatedAppDeploymentMBean(appDeploymentMBean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackUpdate(DeploymentContext deploymentContext) {
        String[] stringArray = this.getUpdatedResourceURIs(deploymentContext);
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("rollbackUpdate " + this.appCtx.getApplicationId() + " uris --> " + StringUtils.join((String[])stringArray, (String)","));
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.previousState(new PrepareUpdateStateChange(stringArray), this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                J2EELogger.logIgnoringRollbackUpdateError((String)this.appCtx.getApplicationId(), (Throwable)stateChangeException.getCause());
                Object var6_5 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var6_4 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adminToProduction(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("adminToProduction " + this.appCtx.getApplicationId());
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.nextState(adminStateChange, this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var5_4 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var5_3 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("forceProductionToAdmin " + this.appCtx.getApplicationId());
        }
        Deployment.AdminModeCallback adminModeCallback = null;
        if (deploymentContext != null) {
            adminModeCallback = deploymentContext.getAdminModeCallback();
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.previousState(new ForceProdToAdminStateChange(adminModeCallback), this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var6_5 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var6_4 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        if (EarUtils.isDebugOn()) {
            EarUtils.debug("gracefulProductionToAdmin " + this.appCtx.getApplicationId());
        }
        Deployment.AdminModeCallback adminModeCallback = null;
        if (deploymentContext != null) {
            adminModeCallback = deploymentContext.getAdminModeCallback();
        }
        ClassLoader classLoader = this.pushLoader();
        try {
            try {
                this.propagateDeploymentContext(deploymentContext);
                this.driver.previousState(new GracefulProdToAdminStateChange(adminModeCallback), this.getFlow());
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var6_5 = null;
                this.resetDeploymentContext();
                this.popLoader(classLoader);
            }
            Object var6_4 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.resetDeploymentContext();
            this.popLoader(classLoader);
            throw throwable;
        }
    }

    private void setModuleURItoModuleIdMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Module module : this.appCtx.getApplicationModules()) {
            if (module instanceof ModuleWrapper) {
                module = ((ModuleWrapper)module).unwrap();
            }
            String string = module.getId();
            if (module instanceof ModuleLocationInfo) {
                hashMap.put(((ModuleLocationInfo)module).getModuleURI(), string);
            }
            hashMap.put(string, string);
        }
        this.appCtx.setModuleURItoIdMap(hashMap);
    }

    public ApplicationContext getApplicationContext() {
        return this.appCtx;
    }

    private static final class ValidateRedeployStateChange
    implements StateChange {
        private final DeploymentContext deplCtx;

        ValidateRedeployStateChange(DeploymentContext deploymentContext) {
            this.deplCtx = deploymentContext;
        }

        public String toString() {
            return "validateRedeploy";
        }

        public void next(Object object) throws DeploymentException {
            ((Flow)object).validateRedeploy(this.deplCtx);
        }

        public void previous(Object object) {
        }

        public void logRollbackError(StateChangeException stateChangeException) {
        }
    }

    private static final class ForceProdToAdminStateChange
    extends AdminCallbackStateChange
    implements StateChange {
        ForceProdToAdminStateChange(Deployment.AdminModeCallback adminModeCallback) {
            super(adminModeCallback);
        }

        public String toString() {
            return "forceProdToAdmin";
        }

        public void previous(Object object) throws Exception {
            ((Flow)object).forceProductionToAdmin(this.barrier);
        }
    }

    private static final class GracefulProdToAdminStateChange
    extends AdminCallbackStateChange
    implements StateChange {
        public String toString() {
            return "gracefulProdToAdmin";
        }

        GracefulProdToAdminStateChange(Deployment.AdminModeCallback adminModeCallback) {
            super(adminModeCallback);
        }

        public void previous(Object object) throws Exception {
            ((Flow)object).gracefulProductionToAdmin(this.barrier);
        }
    }

    private static abstract class AdminCallbackStateChange
    implements StateChange {
        protected final AdminModeCompletionBarrier barrier;

        AdminCallbackStateChange(Deployment.AdminModeCallback adminModeCallback) {
            this.barrier = new AdminModeCompletionBarrier(adminModeCallback);
        }

        public String toString() {
            return "adminCallback";
        }

        public void next(Object object) throws Exception {
            throw new AssertionError((Object)"should not be called");
        }

        public abstract void previous(Object var1) throws Exception;

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringAdminModeErrro((Throwable)stateChangeException.getCause());
        }
    }

    private static final class ActivateUpdateStateChange
    implements StateChange {
        private String[] updateURIs;

        ActivateUpdateStateChange(String[] stringArray) {
            this.updateURIs = stringArray;
        }

        public String toString() {
            return "activateUpdate";
        }

        public void next(Object object) throws Exception {
            ((Flow)object).activateUpdate(this.updateURIs);
        }

        public void previous(Object object) throws Exception {
        }

        public void logRollbackError(StateChangeException stateChangeException) {
        }
    }

    private static final class PrepareUpdateStateChange
    implements StateChange {
        private String[] updateURIs;

        PrepareUpdateStateChange(String[] stringArray) {
            this.updateURIs = stringArray;
        }

        public String toString() {
            return "prepareUpdate";
        }

        public void next(Object object) throws Exception {
            ((Flow)object).prepareUpdate(this.updateURIs);
        }

        public void previous(Object object) throws Exception {
            ((Flow)object).rollbackUpdate(this.updateURIs);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            J2EELogger.logIgnoringUndeploymentError((Throwable)stateChangeException.getCause());
        }
    }
}

