/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.File;
import java.io.IOException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ModuleException;
import weblogic.application.internal.ComponentMBeanHelper;
import weblogic.application.utils.EarUtils;
import weblogic.descriptor.DescriptorBean;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.ejb.container.EJBDebugService;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.runtime.LibraryRuntimeMBean;
import weblogic.utils.jars.VirtualJarFile;

public abstract class BaseJ2EEModule {
    private static final DebugLogger debugLogger = EJBDebugService.deploymentLogger;

    protected final ComponentMBean findComponentMBeanInternal(ApplicationContextInternal applicationContextInternal, String string, Class clazz) throws ModuleException {
        ComponentMBean componentMBean = ComponentMBeanHelper.findComponentMBeanByURI(applicationContextInternal.getApplicationMBean(), string, clazz);
        if (componentMBean != null) {
            return componentMBean;
        }
        LibraryRuntimeMBean[] libraryRuntimeMBeanArray = applicationContextInternal.getRuntime().getLibraryRuntimes();
        if (libraryRuntimeMBeanArray != null) {
            for (int i = 0; i < libraryRuntimeMBeanArray.length; ++i) {
                componentMBean = ComponentMBeanHelper.findComponentMBeanByURI(libraryRuntimeMBeanArray[i].getComponents(), string, clazz);
                if (componentMBean == null) continue;
                return componentMBean;
            }
        }
        return null;
    }

    protected final ComponentMBean findComponentMBean(ApplicationContextInternal applicationContextInternal, String string, Class clazz) throws ModuleException {
        ComponentMBean componentMBean = this.findComponentMBeanInternal(applicationContextInternal, string, clazz);
        if (componentMBean != null) {
            return componentMBean;
        }
        throw new ModuleException("No ComponentMBean was found in Application " + applicationContextInternal.getApplicationName() + " with the URI " + string);
    }

    protected File resolveAltDD(ApplicationContextInternal applicationContextInternal, String string) throws ModuleException {
        ApplicationBean applicationBean = applicationContextInternal.getApplicationDD();
        if (applicationBean == null) {
            return null;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            if (!EarUtils.reallyGetModuleURI(moduleBeanArray[i]).equals(string)) continue;
            String string2 = moduleBeanArray[i].getAltDd();
            if (string2 == null) {
                return null;
            }
            VirtualJarFile virtualJarFile = null;
            try {
                virtualJarFile = applicationContextInternal.getApplicationFileManager().getVirtualJarFile();
                File[] fileArray = virtualJarFile.getRootFiles();
                for (int j = 0; j < fileArray.length; ++j) {
                    File file = new File(fileArray[j], string2);
                    if (!file.exists()) continue;
                    File file2 = file;
                    return file2;
                }
            }
            catch (IOException iOException) {
                throw new ModuleException(iOException);
            }
            finally {
                try {
                    if (virtualJarFile != null) {
                        virtualJarFile.close();
                    }
                }
                catch (IOException iOException) {}
            }
            throw new ModuleException("Unable to find the alt-dd for module " + string + " with the alt-dd " + string2);
        }
        return null;
    }

    public DescriptorBean[] getDescriptors() {
        return new DescriptorBean[0];
    }

    protected boolean acceptModuleUri(ApplicationContextInternal applicationContextInternal, String string, String string2) {
        String string3 = string + "/";
        BaseJ2EEModule.debug("module uri prefix: " + string3);
        BaseJ2EEModule.debug("module uri: " + string2);
        return !applicationContextInternal.isEar() || string2.startsWith(string3);
    }

    protected String mangle(ApplicationContextInternal applicationContextInternal, String string, String string2) {
        return applicationContextInternal.isEar() ? string + "/" + string2 : string2;
    }

    protected String unmangle(ApplicationContextInternal applicationContextInternal, String string, String string2) {
        if (applicationContextInternal.isEar() && string2.startsWith(string)) {
            return string2.substring(string.length());
        }
        return string2;
    }

    private static void debug(String string) {
        debugLogger.debug("[BaseJ2EEModule] " + string);
    }
}

