/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.File;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.application.DeploymentManager;
import weblogic.application.MBeanFactory;
import weblogic.application.ModuleListener;
import weblogic.application.internal.BackgroundDeployment;
import weblogic.application.internal.DeploymentStateChecker;
import weblogic.application.internal.DeploymentTimer;
import weblogic.j2ee.J2EELogger;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.Debug;
import weblogic.utils.collections.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeploymentManagerImpl
extends DeploymentManager {
    private static final boolean TIMES = Debug.getCategory((String)"weblogic.application.times").isEnabled();
    private static final ApplicationFactoryManager afm = ApplicationFactoryManager.getApplicationFactoryManager();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final Map<String, Deployment> deployments = new ConcurrentHashMap();
    private final MBeanFactory mbeanFactory;
    private List<ModuleListener> listeners = Collections.emptyList();

    private String getId(BasicDeploymentMBean basicDeploymentMBean) {
        if (basicDeploymentMBean instanceof AppDeploymentMBean) {
            return ((AppDeploymentMBean)basicDeploymentMBean).getApplicationIdentifier();
        }
        return basicDeploymentMBean.getName();
    }

    public DeploymentManagerImpl() {
        this.mbeanFactory = MBeanFactory.getMBeanFactory();
        RuntimeAccess runtimeAccess = ManagementService.getRuntimeAccess(kernelId);
        assert (runtimeAccess != null);
        assert (runtimeAccess.getServer() != null);
        runtimeAccess.getServer().getStagingDirectoryName();
    }

    @Override
    public Deployment createDeployment(BasicDeploymentMBean basicDeploymentMBean, File file) throws DeploymentException {
        DeploymentFactory deploymentFactory;
        Iterator<DeploymentFactory> iterator = afm.getDeploymentFactories();
        while (iterator.hasNext()) {
            deploymentFactory = iterator.next();
            Deployment deployment = null;
            deployment = basicDeploymentMBean instanceof AppDeploymentMBean ? deploymentFactory.createDeployment((AppDeploymentMBean)basicDeploymentMBean, file) : deploymentFactory.createDeployment((SystemResourceMBean)basicDeploymentMBean, file);
            if (deployment == null) continue;
            deployment = TIMES ? (this.isBackgroundDeployment(basicDeploymentMBean) ? new BackgroundDeployment(new DeploymentTimer(deployment)) : deployment) : (this.isBackgroundDeployment(basicDeploymentMBean) ? new BackgroundDeployment(deployment) : deployment);
            deployment = TIMES ? new DeploymentTimer(deployment) : new DeploymentStateChecker(deployment);
            this.deployments.put(this.getId(basicDeploymentMBean), deployment);
            return deployment;
        }
        deploymentFactory = J2EELogger.logInvalidApplicationLoggable((String)file.getAbsolutePath());
        throw new DeploymentException(deploymentFactory.getMessage());
    }

    @Override
    public Deployment findDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        return this.deployments.get(this.getId(basicDeploymentMBean));
    }

    @Override
    public Deployment findDeployment(String string) {
        return this.deployments.get(string);
    }

    @Override
    public Deployment removeDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        return this.deployments.remove(this.getId(basicDeploymentMBean));
    }

    @Override
    public Deployment removeDeployment(String string) {
        return this.deployments.remove(string);
    }

    @Override
    public Iterator<Deployment> getDeployments() {
        return this.deployments.values().iterator();
    }

    @Override
    public MBeanFactory getMBeanFactory() {
        return this.mbeanFactory;
    }

    @Override
    public synchronized void addModuleListener(ModuleListener moduleListener) {
        ArrayList<ModuleListener> arrayList = new ArrayList<ModuleListener>(this.listeners.size() + 1);
        arrayList.addAll(this.listeners);
        arrayList.add(moduleListener);
        this.listeners = arrayList;
    }

    @Override
    public synchronized void removeModuleListener(ModuleListener moduleListener) {
        ArrayList<ModuleListener> arrayList = new ArrayList<ModuleListener>(this.listeners.size() - 1);
        for (ModuleListener moduleListener2 : this.listeners) {
            if (moduleListener.equals(moduleListener2)) continue;
            arrayList.add(moduleListener2);
        }
        this.listeners = arrayList;
    }

    @Override
    public Iterator<ModuleListener> getModuleListeners() {
        return this.listeners.iterator();
    }

    private boolean isBackgroundDeployment(BasicDeploymentMBean basicDeploymentMBean) {
        if (!(basicDeploymentMBean instanceof AppDeploymentMBean)) {
            return false;
        }
        if (((AppDeploymentMBean)basicDeploymentMBean).isBackgroundDeployment()) {
            String string = ManagementService.getRuntimeAccess(kernelId).getServerRuntime().getState();
            return !string.equals("ADMIN") && !string.equals("RUNNING");
        }
        return false;
    }
}

