/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.application.ApplicationContext;
import weblogic.application.Deployment;
import weblogic.application.DeploymentWrapper;
import weblogic.application.utils.EarUtils;
import weblogic.deploy.common.Debug;
import weblogic.deploy.container.DeploymentContext;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.deploy.internal.DeployerRuntimeLogger;
import weblogic.utils.StringUtils;

public class DeploymentStateChecker
implements Deployment,
DeploymentWrapper {
    public static final int STATE_NEW = 0;
    public static final int STATE_PREPARED = 1;
    public static final int STATE_ADMIN = 2;
    public static final int STATE_ACTIVE = 3;
    public static final int STATE_PENDING_UPDATE = 4;
    protected final Deployment delegate;
    private final List callbacks = new ArrayList();
    private int state = 0;
    private int preUpdateState;
    private int pendingUpdates = 0;

    public DeploymentStateChecker(Deployment deployment) {
        this.delegate = deployment;
    }

    public int getState() {
        return this.state;
    }

    public Deployment getDeployment() {
        return this.delegate;
    }

    public static String state2String(int n) {
        switch (n) {
            case 0: {
                return "STATE_NEW";
            }
            case 1: {
                return "STATE_PREPARED";
            }
            case 2: {
                return "STATE_ADMIN";
            }
            case 3: {
                return "STATE_ACTIVE";
            }
            case 4: {
                return "STATE_PENDING_UPDATE";
            }
        }
        throw new AssertionError((Object)("unexpected state: " + n));
    }

    private void throwAssertion(String string) {
        DeploymentAssertionError deploymentAssertionError = null;
        if (Debug.isDeploymentDebugEnabled()) {
            deploymentAssertionError = new DeploymentAssertionError("\n\n\n*********   YOU HAVE ENCOUNTERED A DEPLOYMENT BUG *********\n\n" + string + "\n\n\n", this.callbacks);
            ((Throwable)((Object)deploymentAssertionError)).printStackTrace();
        } else {
            deploymentAssertionError = new DeploymentAssertionError(string, this.callbacks);
        }
        Loggable loggable = DeployerRuntimeLogger.logInternalErrorLoggable((Throwable)((Object)deploymentAssertionError));
        loggable.log();
    }

    private void assertState(int n, int n2) {
        if (this.state != n && this.state != n2) {
            this.throwAssertion("Unexpected current state for application " + this.getApplicationContext().getApplicationId() + " " + DeploymentStateChecker.state2String(this.state) + ".  We expected us to be in " + DeploymentStateChecker.state2String(n) + " or " + DeploymentStateChecker.state2String(n2));
        }
    }

    private void illegal(int n, int n2) {
        this.throwAssertion("Unexpected transition: current state for application " + this.getApplicationContext().getApplicationId() + " : " + DeploymentStateChecker.state2String(n) + " attempt to transition to " + DeploymentStateChecker.state2String(n2));
    }

    private void up(int n) {
        if (n - this.state == 1) {
            if (EarUtils.isDebugOn()) {
                EarUtils.debug("transitioned from " + DeploymentStateChecker.state2String(this.state) + " to " + DeploymentStateChecker.state2String(n) + " " + this.delegate.getApplicationContext().getApplicationId());
            }
            this.state = n;
        } else {
            this.illegal(this.state, n);
        }
    }

    private void down(int n, boolean bl) {
        if (this.state - n == 1) {
            if (EarUtils.isDebugOn()) {
                EarUtils.debug("transition from " + DeploymentStateChecker.state2String(this.state) + " to " + DeploymentStateChecker.state2String(n) + " " + this.delegate.getApplicationContext().getApplicationId());
            }
            this.state = n;
        } else {
            if (EarUtils.isDebugOn()) {
                EarUtils.debug("Illegal state transition: " + DeploymentStateChecker.state2String(this.state) + " -> " + DeploymentStateChecker.state2String(n));
            }
            if (!bl || n != 2 || this.state != 2) {
                this.illegal(this.state, n);
            }
        }
    }

    private void save(String string) {
        this.callbacks.add(new Exception(string));
    }

    public void prepare(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("prepare");
        this.delegate.prepare(deploymentContext);
        this.up(1);
    }

    public void activate(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("activate");
        this.delegate.activate(deploymentContext);
        this.up(2);
    }

    public void adminToProduction(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("adminToProduction");
        this.delegate.adminToProduction(deploymentContext);
        this.up(3);
    }

    public void gracefulProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("gracefulProductionToAdmin");
        this.down(2, true);
        this.delegate.gracefulProductionToAdmin(deploymentContext);
    }

    public void forceProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("forceProductionToAdmin");
        if (this.state != 2) {
            this.down(2, true);
        }
        this.delegate.forceProductionToAdmin(deploymentContext);
    }

    public void deactivate(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("deactivate");
        this.down(1, false);
        this.delegate.deactivate(deploymentContext);
    }

    public void unprepare(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("unprepare");
        this.down(0, false);
        this.delegate.unprepare(deploymentContext);
    }

    public void remove(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("remove");
        if (this.state != 0) {
            this.illegal(this.state, 0);
        }
        this.delegate.remove(deploymentContext);
    }

    public void prepareUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("prepareUpdate uris: " + this.getUrisAsString(deploymentContext));
        this.delegate.prepareUpdate(deploymentContext);
        if (this.state == 2 || this.state == 3) {
            this.preUpdateState = this.state;
            this.pendingUpdates = 1;
            this.state = 4;
        } else if (this.state == 4) {
            ++this.pendingUpdates;
        } else {
            this.illegal(this.state, 4);
        }
    }

    public void rollbackUpdate(DeploymentContext deploymentContext) {
        String[] stringArray = null;
        if (deploymentContext != null) {
            stringArray = deploymentContext.getUpdatedResourceURIs();
        }
        this.save("rollbackUpdate uris: " + this.getUrisAsString(deploymentContext));
        if (this.state != 4) {
            this.illegal(this.state, 3);
        }
        --this.pendingUpdates;
        if (this.pendingUpdates == 0) {
            this.state = this.preUpdateState;
        }
        this.delegate.rollbackUpdate(deploymentContext);
    }

    public void activateUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("activateUpdate uris: " + this.getUrisAsString(deploymentContext));
        if (this.state != 4) {
            this.illegal(this.state, 3);
        }
        --this.pendingUpdates;
        if (this.pendingUpdates == 0) {
            this.state = this.preUpdateState;
        }
        this.delegate.activateUpdate(deploymentContext);
    }

    public void stop(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("stop");
        this.assertState(2, 3);
        this.delegate.stop(deploymentContext);
    }

    public void start(DeploymentContext deploymentContext) throws DeploymentException {
        this.save("start");
        this.assertState(2, 3);
        this.delegate.start(deploymentContext);
    }

    public ApplicationContext getApplicationContext() {
        return this.delegate.getApplicationContext();
    }

    private String getUrisAsString(DeploymentContext deploymentContext) {
        String[] stringArray = null;
        if (deploymentContext != null) {
            stringArray = deploymentContext.getUpdatedResourceURIs();
        }
        if (stringArray == null) {
            return "";
        }
        return StringUtils.join((String[])stringArray, (String)",");
    }

    private static class DeploymentAssertionError
    extends AssertionError {
        private final List callbacks;

        DeploymentAssertionError(String string, List list) {
            super((Object)string);
            this.callbacks = list;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(super.toString());
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.printCallbacks(printWriter);
            printWriter.flush();
            stringBuffer.append(stringWriter.toString());
            return stringBuffer.toString();
        }

        public void printStackTrace(PrintStream printStream) {
            super.printStackTrace(printStream);
            this.printStackTrace(new PrintWriter(new OutputStreamWriter(printStream)));
        }

        public void printStackTrace(PrintWriter printWriter) {
            super.printStackTrace(printWriter);
            this.printCallbacks(printWriter);
        }

        private void printCallbacks(PrintWriter printWriter) {
            printWriter.println("\n\nDumping " + this.callbacks.size() + " callbacks");
            printWriter.println("----------------------   BEGIN CALLBACK DUMP -------");
            Iterator iterator = this.callbacks.iterator();
            while (iterator.hasNext()) {
                printWriter.println("\n");
                ((Exception)iterator.next()).printStackTrace(printWriter);
                printWriter.println("\n");
            }
            printWriter.println("----------------------   END CALLBACK DUMP -------");
        }
    }
}

