/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import weblogic.application.ApplicationContext;
import weblogic.application.Deployment;
import weblogic.application.internal.DeploymentStateChecker;
import weblogic.deploy.container.DeploymentContext;
import weblogic.j2ee.J2EELogger;
import weblogic.management.DeploymentException;
import weblogic.utils.Debug;
import weblogic.utils.StringUtils;

public final class DeploymentTimer
extends DeploymentStateChecker {
    DeploymentTimer(Deployment deployment) {
        super(deployment);
    }

    private void print(String string, long l) {
        String string2 = string + " on app " + this.getApplicationContext().getApplicationId() + " took " + l + "ms.";
        Debug.say((String)string2);
        J2EELogger.logDebug((String)string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.prepare(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("PREPARE", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.activate(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("ACTIVATE", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.deactivate(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("DEACTIVATE", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.unprepare(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("UNPREPARE", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.remove(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("REMOVE", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.prepareUpdate(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            String[] stringArray = null;
            if (deploymentContext != null) {
                stringArray = deploymentContext.getUpdatedResourceURIs();
            }
            this.print("PREPARE_UPDATE uris: " + StringUtils.join((String[])stringArray, (String)","), l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateUpdate(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.activateUpdate(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            String[] stringArray = null;
            if (deploymentContext != null) {
                stringArray = deploymentContext.getUpdatedResourceURIs();
            }
            this.print("ACTIVATE_UPDATE uris: " + StringUtils.join((String[])stringArray, (String)","), l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackUpdate(DeploymentContext deploymentContext) {
        long l = System.currentTimeMillis();
        try {
            super.rollbackUpdate(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            String[] stringArray = null;
            if (deploymentContext != null) {
                stringArray = deploymentContext.getUpdatedResourceURIs();
            }
            this.print("ROLLBACK_UPDATE uris: " + StringUtils.join((String[])stringArray, (String)","), l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adminToProduction(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.adminToProduction(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("ADMIN_2_PRODUCTION", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gracefulProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.gracefulProductionToAdmin(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("GRACEFUL_PRODUCTION_2_ADMIN", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceProductionToAdmin(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.forceProductionToAdmin(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            this.print("FORCE_PRODUCTION_2_ADMIN", l2 - l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(DeploymentContext deploymentContext) throws DeploymentException {
        long l = System.currentTimeMillis();
        try {
            super.stop(deploymentContext);
        }
        finally {
            long l2 = System.currentTimeMillis();
            String[] stringArray = null;
            if (deploymentContext != null) {
                stringArray = deploymentContext.getUpdatedResourceURIs();
            }
            this.print("STOP uris: " + StringUtils.join((String[])stringArray, (String)","), l2 - l);
        }
    }

    public ApplicationContext getApplicationContext() {
        return super.getApplicationContext();
    }
}

