/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.ApplicationFileManager;
import weblogic.application.ComponentMBeanFactory;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.application.internal.BaseComponentMBeanFactory;
import weblogic.application.internal.EarDeployment;
import weblogic.application.internal.WebServiceUtils;
import weblogic.application.utils.EarUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.wl.JDBCConnectionPoolBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.utils.jars.VirtualJarFile;

public final class EarDeploymentFactory
extends BaseComponentMBeanFactory
implements DeploymentFactory,
ComponentMBeanFactory {
    private WebServiceUtils wsUtils = WebServiceUtils.getWebServiceUtils();

    public Deployment createDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws DeploymentException {
        if (!EarUtils.isEar(file)) {
            return null;
        }
        return new EarDeployment(appDeploymentMBean, file);
    }

    public Deployment createDeployment(SystemResourceMBean systemResourceMBean, File file) throws DeploymentException {
        return null;
    }

    private void addAppComponents(ApplicationFileManager applicationFileManager, VirtualJarFile virtualJarFile, List list, ApplicationBean applicationBean, ApplicationMBean applicationMBean, AppDeploymentMBean appDeploymentMBean) throws IOException {
        if (applicationBean == null) {
            throw new IOException("No META-INF/application.xml was found in the EAR " + applicationMBean.getName());
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray == null) {
            return;
        }
        Set set = this.wsUtils.findWebServices(applicationMBean, applicationFileManager, virtualJarFile, moduleBeanArray);
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            ComponentMBeanFactory.MBeanFactory mBeanFactory = null;
            String string = null;
            String string2 = null;
            if (moduleBeanArray[i].getEjb() != null) {
                mBeanFactory = EJB_COMP;
                string = moduleBeanArray[i].getEjb();
            } else if (moduleBeanArray[i].getWeb() != null) {
                string = moduleBeanArray[i].getWeb().getWebUri();
                string2 = EarUtils.fixAppContextRoot(moduleBeanArray[i].getWeb().getContextRoot());
                if (string2 == null || "".equals(string2) || "/".equals(string2)) {
                    string2 = string;
                }
                mBeanFactory = set.contains(string) ? WEB_SERVICE_COMP : WEB_COMP;
            } else if (moduleBeanArray[i].getConnector() != null) {
                string = moduleBeanArray[i].getConnector();
                mBeanFactory = CONNECTOR_COMP;
            }
            if (mBeanFactory == null) continue;
            if (appDeploymentMBean != null) {
                if (string2 == null) {
                    string2 = string;
                }
                string2 = this.getCompatibilityName(string2, appDeploymentMBean);
            }
            list.add(this.findOrCreateComponentMBean(mBeanFactory, applicationMBean, string2, string));
        }
    }

    protected String getCompatibilityName(String string, AppDeploymentMBean appDeploymentMBean) {
        SubDeploymentMBean subDeploymentMBean = appDeploymentMBean.lookupSubDeployment(string);
        if (subDeploymentMBean == null) {
            return string;
        }
        String string2 = subDeploymentMBean.getCompatibilityName();
        if (string2 == null) {
            return string;
        }
        return string2;
    }

    private void addWLAppComponents(List list, WeblogicApplicationBean weblogicApplicationBean, ApplicationMBean applicationMBean) {
        if (weblogicApplicationBean == null) {
            return;
        }
        JDBCConnectionPoolBean[] jDBCConnectionPoolBeanArray = weblogicApplicationBean.getJDBCConnectionPools();
        if (jDBCConnectionPoolBeanArray == null || jDBCConnectionPoolBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < jDBCConnectionPoolBeanArray.length; ++i) {
            String string = jDBCConnectionPoolBeanArray[i].getDataSourceJNDIName();
            list.add(this.findOrCreateComponentMBean(JDBC_COMP, applicationMBean, string));
        }
    }

    public boolean needsApplicationPathMunging() {
        return false;
    }

    public ComponentMBean[] findOrCreateComponentMBeans(ApplicationMBean applicationMBean, File file, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        if (!EarUtils.isEar(file)) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        VirtualJarFile virtualJarFile = null;
        try {
            ApplicationFileManager applicationFileManager = ApplicationFileManager.newInstance(file);
            virtualJarFile = applicationFileManager.getVirtualJarFile();
            boolean bl = appDeploymentMBean == null ? true : appDeploymentMBean.isInternalApp();
            ApplicationDescriptor applicationDescriptor = new ApplicationDescriptor(applicationMBean.getName(), bl, virtualJarFile, null, null, file.getName());
            this.addAppComponents(applicationFileManager, virtualJarFile, arrayList, applicationDescriptor.getApplicationDescriptor(), applicationMBean, appDeploymentMBean);
            this.addWLAppComponents(arrayList, applicationDescriptor.getWeblogicApplicationDescriptor(), applicationMBean);
            ComponentMBean[] componentMBeanArray = arrayList.toArray(new ComponentMBean[arrayList.size()]);
            return componentMBeanArray;
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeploymentException(xMLStreamException.getMessage(), xMLStreamException);
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException.getMessage(), iOException);
        }
        finally {
            if (virtualJarFile != null) {
                try {
                    virtualJarFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

