/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.File;
import java.security.AccessController;
import java.util.Iterator;
import javax.management.InvalidAttributeValueException;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.ComponentMBeanFactory;
import weblogic.application.MBeanFactory;
import weblogic.management.ApplicationException;
import weblogic.management.DeploymentException;
import weblogic.management.DomainDir;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.management.configuration.ComponentMBean;
import weblogic.management.configuration.DomainMBean;
import weblogic.management.deploy.internal.MBeanConverter;
import weblogic.management.provider.ManagementService;
import weblogic.management.utils.AppDeploymentHelper;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class MBeanFactoryImpl
extends MBeanFactory {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private ApplicationFactoryManager afm = ApplicationFactoryManager.getApplicationFactoryManager();

    private ComponentMBeanFactory findOrCreateComponentMBeans(ApplicationMBean applicationMBean, File file, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        Iterator<ComponentMBeanFactory> iterator = this.afm.getComponentMBeanFactories();
        while (iterator.hasNext()) {
            ComponentMBeanFactory componentMBeanFactory = iterator.next();
            ComponentMBean[] componentMBeanArray = componentMBeanFactory.findOrCreateComponentMBeans(applicationMBean, file, appDeploymentMBean);
            if (componentMBeanArray == null) continue;
            return componentMBeanFactory;
        }
        return ComponentMBeanFactory.DEFAULT_FACTORY;
    }

    public ApplicationMBean initializeMBeans(DomainMBean domainMBean, File file, String string, String string2, String string3, AppDeploymentMBean appDeploymentMBean) throws ApplicationException {
        ApplicationMBean applicationMBean = null;
        boolean bl = false;
        try {
            applicationMBean = this.createApplicationMBean(domainMBean, string, string2, string3);
            ComponentMBeanFactory componentMBeanFactory = this.createComponentMBeans(file, applicationMBean, appDeploymentMBean);
            this.initializeAppMBeanPath(componentMBeanFactory, applicationMBean, file);
            bl = true;
            ApplicationMBean applicationMBean2 = applicationMBean;
            return applicationMBean2;
        }
        catch (ManagementException managementException) {
            throw new ApplicationException((Exception)((Object)managementException));
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new AssertionError((Object)invalidAttributeValueException);
        }
        finally {
            if (!bl) {
                this.cleanupMBeans(domainMBean, applicationMBean);
            } else if (applicationMBean != null) {
                applicationMBean.setDelegationEnabled(true);
            }
        }
    }

    private ComponentMBeanFactory createComponentMBeans(File file, ApplicationMBean applicationMBean, AppDeploymentMBean appDeploymentMBean) throws DeploymentException {
        File file2 = file;
        if (!file2.isAbsolute()) {
            file2 = new File(this.resolveWithRootDirectory(file2.getPath()));
        }
        return this.findOrCreateComponentMBeans(applicationMBean, file2, appDeploymentMBean);
    }

    private void initializeAppMBeanPath(ComponentMBeanFactory componentMBeanFactory, ApplicationMBean applicationMBean, File file) throws ManagementException, InvalidAttributeValueException {
        if (componentMBeanFactory.needsApplicationPathMunging()) {
            applicationMBean.setPath(file.getParent());
        } else {
            applicationMBean.setPath(file.getPath());
        }
    }

    private ApplicationMBean createApplicationMBean(DomainMBean domainMBean, String string, String string2, String string3) {
        ApplicationMBean applicationMBean = domainMBean.lookupApplication(string);
        if (applicationMBean == null) {
            applicationMBean = domainMBean.createApplication(string);
        }
        applicationMBean.setAltDescriptorPath(string2);
        applicationMBean.setAltWLSDescriptorPath(string3);
        return applicationMBean;
    }

    public void reconcileMBeans(AppDeploymentMBean appDeploymentMBean, File file) throws ApplicationException {
        try {
            this.findOrCreateComponentMBeans(appDeploymentMBean.getAppMBean(), file, appDeploymentMBean);
        }
        catch (ManagementException managementException) {
            throw new ApplicationException((Exception)((Object)managementException));
        }
    }

    public void cleanupMBeans(DomainMBean domainMBean, ApplicationMBean applicationMBean) {
        if (applicationMBean != null) {
            DomainMBean domainMBean2;
            AppDeploymentMBean appDeploymentMBean = AppDeploymentHelper.lookupAppOrLib(applicationMBean.getName(), domainMBean);
            if (appDeploymentMBean != null && domainMBean != (domainMBean2 = ManagementService.getRuntimeAccess(kernelId).getDomain())) {
                MBeanConverter.debug("MBeanFactoryImpl: Destroy " + appDeploymentMBean.getName() + " from " + domainMBean.getName());
                AppDeploymentHelper.destroyAppOrLib(appDeploymentMBean, domainMBean);
            }
            MBeanConverter.debug("MBeanFactoryImpl: Destroy " + applicationMBean.getName() + " from " + domainMBean.getName());
            domainMBean.destroyApplication(applicationMBean);
        }
    }

    private String resolveWithRootDirectory(String string) {
        return DomainDir.getRootDir() + File.separatorChar + string;
    }
}

