/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import weblogic.application.ApplicationFileManager;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.management.configuration.ApplicationMBean;
import weblogic.utils.jars.VirtualJarFile;

public final class WebServiceUtils
implements J2EEApplicationService.HaltListener {
    private static boolean DEBUG = false;
    private static final String WEB_SERVICES_URI = "WEB-INF/web-services.xml";
    private static final String WEB_URI = "WEB-INF/web-services.xml";
    private static String FILE_NAME = "WebServiceUtils.ser";
    private LinkedList cacheList;
    private static final int MAX_LIST_SIZE = 20;
    private File serFile = new File(J2EEApplicationService.getTempDir(), FILE_NAME);

    private WebServiceUtils() {
        this.cacheList = this.readSavedCache();
        J2EEApplicationService.registerHaltListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedList readSavedCache() {
        if (!this.serFile.exists()) {
            return new LinkedList();
        }
        ObjectInputStream objectInputStream = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.serFile);
            objectInputStream = new ObjectInputStream(fileInputStream);
            LinkedList linkedList = (LinkedList)objectInputStream.readObject();
            return linkedList;
        }
        catch (Exception exception) {
            if (DEBUG) {
                exception.printStackTrace();
            }
            LinkedList linkedList = new LinkedList();
            return linkedList;
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        ObjectOutputStream objectOutputStream = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.serFile);
            objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.cacheList);
        }
        catch (IOException iOException) {
            if (DEBUG) {
                iOException.printStackTrace();
            }
        }
        finally {
            if (objectOutputStream != null) {
                try {
                    objectOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static WebServiceUtils getWebServiceUtils() {
        return WebServiceUtilsSingleton.SINGLETON;
    }

    private boolean isCacheable(VirtualJarFile virtualJarFile) {
        return !virtualJarFile.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set readCache(ApplicationMBean applicationMBean, VirtualJarFile virtualJarFile) {
        if (!this.isCacheable(virtualJarFile)) {
            return null;
        }
        String string = applicationMBean.getName();
        LinkedList linkedList = this.cacheList;
        synchronized (linkedList) {
            Iterator iterator = this.cacheList.iterator();
            while (iterator.hasNext()) {
                CacheEntry cacheEntry = (CacheEntry)iterator.next();
                if (!cacheEntry.appName.equals(string)) continue;
                File file = virtualJarFile.getRootFiles()[0];
                iterator.remove();
                if (file.lastModified() == cacheEntry.lastModified) {
                    this.cacheList.addFirst(cacheEntry);
                    return cacheEntry.wsSet;
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCache(ApplicationMBean applicationMBean, VirtualJarFile virtualJarFile, Set set) {
        if (!this.isCacheable(virtualJarFile)) {
            return;
        }
        File file = virtualJarFile.getRootFiles()[0];
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.appName = applicationMBean.getName();
        cacheEntry.lastModified = file.lastModified();
        cacheEntry.wsSet = set;
        LinkedList linkedList = this.cacheList;
        synchronized (linkedList) {
            this.cacheList.addFirst(cacheEntry);
            if (this.cacheList.size() > 20) {
                this.cacheList.removeLast();
            }
        }
    }

    Set findWebServices(ApplicationMBean applicationMBean, ApplicationFileManager applicationFileManager, VirtualJarFile virtualJarFile, ModuleBean[] moduleBeanArray) throws IOException {
        HashSet<String> hashSet = this.readCache(applicationMBean, virtualJarFile);
        if (hashSet != null) {
            return hashSet;
        }
        hashSet = Collections.EMPTY_SET;
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            String string;
            if (moduleBeanArray[i].getWeb() == null || !this.isWebService(applicationFileManager, virtualJarFile, string = moduleBeanArray[i].getWeb().getWebUri())) continue;
            if (hashSet.size() == 0) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string);
        }
        this.updateCache(applicationMBean, virtualJarFile, hashSet);
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isWebService(ApplicationFileManager applicationFileManager, VirtualJarFile virtualJarFile, String string) throws IOException {
        if (virtualJarFile.isDirectory()) {
            VirtualJarFile virtualJarFile2 = null;
            try {
                virtualJarFile2 = applicationFileManager.getVirtualJarFile(string);
                boolean bl = virtualJarFile2.getEntry("WEB-INF/web-services.xml") != null;
                return bl;
            }
            finally {
                if (virtualJarFile2 != null) {
                    try {
                        virtualJarFile2.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (virtualJarFile.getEntry(string + "/" + "WEB-INF/web-services.xml") != null) {
            if (virtualJarFile.getEntry(string + "/" + "WEB-INF/web-services.xml") == null) return false;
            return true;
        }
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry = virtualJarFile.getEntry(string);
            if (zipEntry == null) {
                boolean bl = false;
                return bl;
            }
            InputStream inputStream = virtualJarFile.getInputStream(zipEntry);
            if (inputStream == null) {
                boolean bl = false;
                return bl;
            }
            zipInputStream = new ZipInputStream(inputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals("WEB-INF/web-services.xml")) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class CacheEntry
    implements Serializable {
        String appName;
        long lastModified;
        Set wsSet;

        private CacheEntry() {
        }
    }

    private static final class WebServiceUtilsSingleton {
        private static final WebServiceUtils SINGLETON = new WebServiceUtils();

        private WebServiceUtilsSingleton() {
        }
    }
}

