/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.Module;
import weblogic.application.internal.Flow;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.internal.flow.ModuleStateDriver;
import weblogic.management.DeploymentException;
import weblogic.utils.ErrorCollectionException;

public final class AdminModulesFlow
extends BaseFlow
implements Flow {
    private ModuleStateDriver driver;

    public AdminModulesFlow(FlowContext flowContext) {
        super(flowContext);
        this.driver = new ModuleStateDriver(this.appCtx);
    }

    public void start(String[] stringArray) throws DeploymentException {
        if (this.appCtx.isAdminState()) {
            return;
        }
        Module[] moduleArray = this.appCtx.getStartingModules();
        try {
            this.driver.adminToProduction(moduleArray);
        }
        catch (Throwable throwable) {
            ErrorCollectionException errorCollectionException = new ErrorCollectionException(throwable);
            try {
                this.driver.deactivate(moduleArray);
            }
            catch (Throwable throwable2) {
                errorCollectionException.add(throwable2);
            }
            try {
                this.driver.unprepare(moduleArray);
            }
            catch (Throwable throwable3) {
                errorCollectionException.add(throwable3);
            }
            try {
                this.driver.destroy(moduleArray);
            }
            catch (Throwable throwable4) {
                errorCollectionException.add(throwable4);
            }
            this.throwAppException((Throwable)errorCollectionException);
        }
    }

    public void stop(String[] stringArray) {
        if (this.appCtx.isAdminState()) {
            return;
        }
        Module[] moduleArray = this.appCtx.getStoppingModules();
        try {
            this.driver.forceProductionToAdmin(moduleArray);
        }
        catch (DeploymentException deploymentException) {
            this.log("Ignoring productionToAdmin error ", (Throwable)((Object)deploymentException));
        }
    }
}

