/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.management.DeploymentException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class ApplicationRuntimeMBeanDeactivationFlow
extends BaseFlow {
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");

    public ApplicationRuntimeMBeanDeactivationFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** gracefulProductionToAdmin " + this.appCtx.getApplicationId()));
        }
        if (ApplicationVersionUtils.getAdminModeAppCtxParam(this.appCtx)) {
            ApplicationVersionUtils.setActiveVersionState(this.appCtx, 1);
            return;
        }
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** gracefulProductionToAdmin " + this.appCtx.getApplicationId() + " does not change active version state"));
        }
    }

    public void forceProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** forceProductionToAdmin " + this.appCtx.getApplicationId()));
        }
        if (ApplicationVersionUtils.getAdminModeAppCtxParam(this.appCtx)) {
            ApplicationVersionUtils.setActiveVersionState(this.appCtx, 1);
            return;
        }
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** forceProductionToAdmin " + this.appCtx.getApplicationId() + " does not change active version state"));
        }
    }

    public void deactivate() throws DeploymentException {
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** deactivate " + this.appCtx.getApplicationId()));
        }
        ApplicationVersionUtils.setActiveVersionState(this.appCtx, 0);
    }
}

