/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.SystemResourceMBean;

public final class ApplicationRuntimeMBeanFlow
extends BaseFlow {
    public ApplicationRuntimeMBeanFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    private J2EEApplicationRuntimeMBeanImpl createRuntime() throws DeploymentException {
        String string = ApplicationVersionUtils.replaceDelimiter(this.appCtx.getApplicationId(), '_');
        try {
            AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
            if (appDeploymentMBean != null) {
                return new J2EEApplicationRuntimeMBeanImpl(string, appDeploymentMBean);
            }
            SystemResourceMBean systemResourceMBean = this.appCtx.getSystemResourceMBean();
            if (systemResourceMBean == null) {
                throw new AssertionError((Object)"neither app or System resource?");
            }
            return new J2EEApplicationRuntimeMBeanImpl(string, systemResourceMBean);
        }
        catch (ManagementException managementException) {
            throw new DeploymentException(managementException);
        }
    }

    public void prepare() throws DeploymentException {
        this.appCtx.setRuntime(this.createRuntime());
    }

    public void unprepare() throws DeploymentException {
        J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
        try {
            j2EEApplicationRuntimeMBeanImpl.unregister();
        }
        catch (Exception exception) {
            throw new DeploymentException(exception);
        }
    }
}

