/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.deployment.AbstractPersistenceUnitRegistry;
import weblogic.deployment.EarPersistenceUnitRegistry;
import weblogic.deployment.EnvironmentException;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.management.DeploymentException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public final class ApplicationRuntimeMBeanSetupFlow
extends BaseFlow {
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");

    public ApplicationRuntimeMBeanSetupFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void activate() throws DeploymentException {
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** activate " + this.appCtx.getApplicationId()));
        }
        this.initPersistenceMBean();
        if (ApplicationVersionUtils.getAdminModeAppCtxParam(this.appCtx)) {
            ApplicationVersionUtils.setActiveVersionState(this.appCtx, 1);
            return;
        }
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** activate " + this.appCtx.getApplicationId() + " does not " + "change active version state"));
        }
    }

    private void initPersistenceMBean() throws DeploymentException {
        J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl;
        AbstractPersistenceUnitRegistry abstractPersistenceUnitRegistry = (AbstractPersistenceUnitRegistry)this.appCtx.getUserObject(EarPersistenceUnitRegistry.class);
        if (abstractPersistenceUnitRegistry != null && (j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime()) != null) {
            try {
                abstractPersistenceUnitRegistry.setParentRuntimeMBean(j2EEApplicationRuntimeMBeanImpl);
            }
            catch (EnvironmentException environmentException) {
                throw new DeploymentException((Throwable)((Object)environmentException));
            }
        }
    }

    public void adminToProduction() throws DeploymentException {
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** adminToProduction " + this.appCtx.getApplicationId()));
        }
        ApplicationVersionUtils.setActiveVersionState(this.appCtx, 2);
    }
}

