/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.Flow;
import weblogic.application.internal.FlowContext;
import weblogic.application.utils.ExceptionUtils;
import weblogic.deploy.container.DeploymentContext;
import weblogic.management.DeploymentException;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

public abstract class BaseFlow
implements Flow {
    private static final boolean VERBOSE = false;
    protected final FlowContext appCtx;

    protected BaseFlow(ApplicationContextInternal applicationContextInternal) {
        this.appCtx = (FlowContext)applicationContextInternal;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.appCtx.toString() + ")";
    }

    protected void throwAppException(Throwable throwable) throws DeploymentException {
        ExceptionUtils.throwDeploymentException(throwable);
    }

    protected static void log(String string) {
        Debug.say((String)string);
    }

    protected void log(String string, Throwable throwable) {
        Debug.say((String)(string + StackTraceUtils.throwable2StackTrace((Throwable)throwable)));
    }

    public void remove() throws DeploymentException {
    }

    public void prepare() throws DeploymentException {
    }

    public void activate() throws DeploymentException {
    }

    public void deactivate() throws DeploymentException {
    }

    public void unprepare() throws DeploymentException {
    }

    public void start(String[] stringArray) throws DeploymentException {
    }

    public void stop(String[] stringArray) throws DeploymentException {
    }

    public void prepareUpdate(String[] stringArray) throws DeploymentException {
    }

    public void activateUpdate(String[] stringArray) throws DeploymentException {
    }

    public void rollbackUpdate(String[] stringArray) throws DeploymentException {
    }

    public void adminToProduction() throws DeploymentException {
    }

    public void forceProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
    }

    public void validateRedeploy(DeploymentContext deploymentContext) throws DeploymentException {
    }
}

