/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import weblogic.application.ApplicationLifecycleEvent;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.application.ApplicationVersionLifecycleListener;
import weblogic.application.DeploymentOperationType;
import weblogic.application.WrappedDeploymentException;
import weblogic.application.internal.Flow;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.TargetUtils;
import weblogic.j2ee.J2EELogger;
import weblogic.jndi.factories.java.javaURLContextFactory;
import weblogic.management.DeploymentException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.GenericClassLoader;

abstract class BaseLifecycleFlow
extends BaseFlow
implements Flow {
    protected static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private boolean isAppDeployedLocally = true;
    private final PreStartAction preStart = new PreStartAction();
    private final PostStartAction postStart = new PostStartAction();
    private final PreStopAction preStop = new PreStopAction();
    private final PostStopAction postStop = new PostStopAction();

    public BaseLifecycleFlow(FlowContext flowContext) {
        super(flowContext);
        this.isAppDeployedLocally = TargetUtils.isDeployedLocally(flowContext.getBasicDeploymentMBean().getTargets());
    }

    private ApplicationLifecycleEvent createEvent() {
        return new ApplicationLifecycleEvent(this.appCtx, DeploymentOperationType.valueOf(this.appCtx.getDeploymentOperation()), this.appCtx.isStaticDeploymentOperation());
    }

    protected void preStart() throws DeploymentException {
        if (this.isAppDeployedLocally) {
            this.preStart.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postStart() throws DeploymentException {
        if (this.isAppDeployedLocally) {
            javaURLContextFactory.pushContext(this.appCtx.getRootContext());
            try {
                this.postStart.invoke();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                javaURLContextFactory.popContext();
                throw throwable;
            }
            javaURLContextFactory.popContext();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preStop() throws DeploymentException {
        if (this.isAppDeployedLocally) {
            javaURLContextFactory.pushContext(this.appCtx.getRootContext());
            try {
                this.preStop.invoke();
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                javaURLContextFactory.popContext();
                throw throwable;
            }
            javaURLContextFactory.popContext();
            {
            }
        }
    }

    protected void postStop() throws DeploymentException {
        if (this.isAppDeployedLocally) {
            this.postStop.invoke();
        }
    }

    private class PostStopAction
    extends AbstractStopAction
    implements PrivilegedAction {
        private PostStopAction() {
        }

        public Object run() {
            try {
                this.listener.postStop(BaseLifecycleFlow.this.createEvent());
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private class PreStopAction
    extends AbstractStopAction
    implements PrivilegedAction {
        private PreStopAction() {
        }

        public Object run() {
            try {
                this.listener.preStop(BaseLifecycleFlow.this.createEvent());
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private abstract class AbstractStopAction
    extends LifecycleListenerAction
    implements PrivilegedAction {
        private AbstractStopAction() {
        }

        protected boolean fail() {
            return false;
        }

        protected Iterator getListeners() {
            ArrayList<ApplicationLifecycleListener> arrayList = new ArrayList<ApplicationLifecycleListener>();
            ApplicationLifecycleListener[] applicationLifecycleListenerArray = BaseLifecycleFlow.this.appCtx.getApplicationListeners();
            for (int i = applicationLifecycleListenerArray.length - 1; i >= 0; --i) {
                arrayList.add(applicationLifecycleListenerArray[i]);
            }
            return arrayList.iterator();
        }
    }

    private class PostStartAction
    extends AbstractStartAction
    implements PrivilegedAction {
        private PostStartAction() {
        }

        public Object run() {
            try {
                this.listener.postStart(BaseLifecycleFlow.this.createEvent());
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    private class PreStartAction
    extends AbstractStartAction
    implements PrivilegedAction {
        private PreStartAction() {
        }

        public Object run() {
            try {
                this.listener.preStart(BaseLifecycleFlow.this.createEvent());
            }
            catch (Throwable throwable) {
                return throwable;
            }
            return null;
        }
    }

    protected class CreateMainClassAction
    extends BaseAction
    implements PrivilegedAction {
        private final GenericClassLoader gcl;
        private final String className;

        CreateMainClassAction(GenericClassLoader genericClassLoader, String string) {
            this.gcl = genericClassLoader;
            this.className = string;
        }

        public Object run() {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.className, false, (ClassLoader)this.gcl);
                if (clazz == null) {
                    return new DeploymentException("Cannot load ApplicationLifecycleListener class " + this.className);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return new DeploymentException(classNotFoundException);
            }
            return clazz;
        }
    }

    private abstract class AbstractStartAction
    extends LifecycleListenerAction
    implements PrivilegedAction {
        private AbstractStartAction() {
        }

        protected boolean fail() {
            return true;
        }

        protected Iterator getListeners() {
            List<ApplicationLifecycleListener> list = Arrays.asList(BaseLifecycleFlow.this.appCtx.getApplicationListeners());
            return list.iterator();
        }
    }

    private abstract class LifecycleListenerAction
    implements PrivilegedAction {
        protected ApplicationLifecycleListener listener = null;

        private LifecycleListenerAction() {
        }

        Object invoke() throws DeploymentException {
            ErrorCollectionException errorCollectionException = null;
            Iterator iterator = this.getListeners();
            while (iterator.hasNext()) {
                Object object;
                this.listener = (ApplicationLifecycleListener)iterator.next();
                AuthenticatedSubject authenticatedSubject = BaseLifecycleFlow.this.appCtx.getAppListenerIdentity(this.listener);
                if (authenticatedSubject == null) {
                    authenticatedSubject = BaseLifecycleFlow.this.appCtx.getDeploymentInitiator();
                }
                if ((object = SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)authenticatedSubject, (PrivilegedAction)this)) == null) continue;
                if (this.fail()) {
                    this.throwsException(object);
                }
                if (errorCollectionException == null) {
                    errorCollectionException = new ErrorCollectionException();
                }
                errorCollectionException.addError((Throwable)object);
            }
            if (errorCollectionException != null && !errorCollectionException.isEmpty()) {
                this.throwsException(errorCollectionException);
            }
            return null;
        }

        private void throwsException(Object object) throws DeploymentException {
            if (object instanceof DeploymentException) {
                throw (DeploymentException)((Object)object);
            }
            if (object instanceof Throwable) {
                throw new WrappedDeploymentException((Throwable)object);
            }
        }

        protected abstract Iterator getListeners();

        protected abstract boolean fail();
    }

    protected class CreateListenerAction
    extends BaseAction
    implements PrivilegedAction {
        private final GenericClassLoader gcl;
        private final String className;
        private final boolean nonVersionOnly;

        CreateListenerAction(GenericClassLoader genericClassLoader, String string, boolean bl) {
            this.gcl = genericClassLoader;
            this.className = string;
            this.nonVersionOnly = bl;
        }

        public Object run() {
            Class<?> clazz = null;
            try {
                clazz = Class.forName(this.className, false, (ClassLoader)this.gcl);
                if (clazz == null) {
                    return new DeploymentException("Cannot load ApplicationLifecycleListener class " + this.className);
                }
                Object obj = clazz.newInstance();
                if (obj instanceof ApplicationLifecycleListener) {
                    return obj;
                }
                if (this.nonVersionOnly) {
                    return new DeploymentException("ApplicationLifecycleListener " + clazz.getName() + " was not an instanceof " + "weblogic.application.ApplicationLifecycleListener");
                }
                if (obj instanceof ApplicationVersionLifecycleListener) {
                    String string = BaseLifecycleFlow.this.appCtx.getApplicationId();
                    if (ApplicationVersionUtils.getVersionId(string) != null) {
                        return obj;
                    }
                    J2EELogger.logIgnoreAppVersionListenerForNonVersionApp((String)ApplicationVersionUtils.getDisplayName(string), (String)this.className);
                    return null;
                }
                return new DeploymentException("Application Lifecycle Listener " + clazz.getName() + " was not an instanceof " + "weblogic.application.ApplicationLifecycleListener or " + "weblogic.application.ApplicationVersionLifecycleListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                return new DeploymentException(classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                return new DeploymentException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                return new DeploymentException(illegalAccessException);
            }
        }
    }

    private abstract class BaseAction
    implements PrivilegedAction {
        private BaseAction() {
        }

        Object invoke() throws DeploymentException {
            Object object = SecurityServiceManager.runAs((AuthenticatedSubject)KERNEL_ID, (AuthenticatedSubject)BaseLifecycleFlow.this.appCtx.getDeploymentInitiator(), (PrivilegedAction)this);
            if (object instanceof DeploymentException) {
                throw (DeploymentException)((Object)object);
            }
            if (object instanceof Throwable) {
                throw new WrappedDeploymentException((Throwable)object);
            }
            return object;
        }
    }
}

