/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.Flow;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;

public class BaseWorkContextFlow
extends BaseFlow
implements Flow {
    private static final DebugCategory DEBUG_APP_VERSION = Debug.getCategory((String)"weblogic.AppVersion");

    public BaseWorkContextFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    protected void setBindApplicationIdCtx(String string) {
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** " + string + " " + (appDeploymentMBean == null ? "" : appDeploymentMBean.getApplicationIdentifier())));
        }
        if (appDeploymentMBean != null && appDeploymentMBean.getVersionIdentifier() != null) {
            ApplicationVersionUtils.setBindApplicationId(appDeploymentMBean.getApplicationIdentifier());
            ApplicationVersionUtils.setCurrentVersionId(appDeploymentMBean.getApplicationName(), appDeploymentMBean.getVersionIdentifier());
        }
    }

    protected void unsetBindApplicationIdCtx(String string) {
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        if (DEBUG_APP_VERSION.isEnabled()) {
            Debug.say((String)("*** " + string + " " + (appDeploymentMBean == null ? "" : appDeploymentMBean.getApplicationIdentifier())));
        }
        if (appDeploymentMBean != null && appDeploymentMBean.getVersionIdentifier() != null) {
            ApplicationVersionUtils.unsetBindApplicationId();
            ApplicationVersionUtils.unsetCurrentVersionId(appDeploymentMBean.getApplicationName());
        }
    }
}

