/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.internal.Flow;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.management.runtime.ComponentRuntimeMBean;

public final class ComponentRuntimeStateFlow
extends BaseFlow
implements Flow {
    public ComponentRuntimeStateFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    private void setDeploymentState(int n) {
        this.setDeploymentState(n, this.appCtx.getApplicationModules());
    }

    private void setDeploymentState(int n, Module[] moduleArray) {
        if (moduleArray == null) {
            return;
        }
        for (int i = 0; i < moduleArray.length; ++i) {
            ComponentRuntimeMBean[] componentRuntimeMBeanArray = moduleArray[i].getComponentRuntimeMBeans();
            if (componentRuntimeMBeanArray == null) continue;
            for (int j = 0; j < componentRuntimeMBeanArray.length; ++j) {
                if (componentRuntimeMBeanArray[j] == null) continue;
                componentRuntimeMBeanArray[j].setDeploymentState(n);
            }
        }
    }

    public void prepare() {
        this.setDeploymentState(1);
    }

    public void activate() {
        this.setDeploymentState(2);
    }

    public void deactivate() {
        this.setDeploymentState(1);
    }

    public void unprepare() {
        this.setDeploymentState(0);
    }

    public void prepareUpdate(String[] stringArray) {
        this.setDeploymentState(4);
    }

    public void activateUpdate(String[] stringArray) {
        this.setDeploymentState(2);
    }

    public void rollbackUpdate(String[] stringArray) {
        this.setDeploymentState(2);
    }
}

