/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.Module;
import weblogic.application.ModuleFactory;
import weblogic.application.ModuleManager;
import weblogic.application.ModuleNotFoundException;
import weblogic.application.ParentModule;
import weblogic.application.WeblogicModuleFactory;
import weblogic.application.internal.AppDDHolder;
import weblogic.application.internal.Flow;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.CustomModulesCreator;
import weblogic.application.internal.flow.JeeModulesCreator;
import weblogic.application.internal.flow.ModuleFilterFlow;
import weblogic.application.internal.flow.ModulesCreator;
import weblogic.application.internal.flow.ScopedModuleDriver;
import weblogic.application.internal.flow.WebLogicExtensionModulesCreator;
import weblogic.application.internal.flow.WebLogicModulesCreator;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.deploy.api.shared.WebLogicModuleType;
import weblogic.deploy.container.DeploymentContext;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public final class CreateModulesFlow
extends ModuleFilterFlow
implements Flow {
    private static final ApplicationFactoryManager afm = ApplicationFactoryManager.getApplicationFactoryManager();

    public CreateModulesFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    private boolean containsModule(String string) {
        WeblogicApplicationBean weblogicApplicationBean;
        WebBean webBean;
        ModuleManager moduleManager = this.appCtx.getModuleManager();
        if (moduleManager.findModuleWithId(string) != null) {
            return true;
        }
        ApplicationBean applicationBean = this.appCtx.getApplicationDD();
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray != null) {
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                webBean = moduleBeanArray[i].getWeb();
                if (webBean == null || !string.equals(webBean.getWebUri())) continue;
                return true;
            }
        }
        if ((weblogicApplicationBean = this.appCtx.getWLApplicationDD()) != null && (webBean = weblogicApplicationBean.getModules()) != null) {
            for (int i = 0; i < ((WebBean)webBean).length; ++i) {
                if (!string.equals(webBean[i].getName())) continue;
                return true;
            }
        }
        return false;
    }

    private void validateTargets() throws DeploymentException {
        SubDeploymentMBean[] subDeploymentMBeanArray = this.appCtx.getBasicDeploymentMBean().getSubDeployments();
        if (subDeploymentMBeanArray == null || subDeploymentMBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            if (this.containsModule(subDeploymentMBeanArray[i].getName())) continue;
            throw new DeploymentException("The application " + this.appCtx.getApplicationId() + " contains a SubDeploymentMBean with a name " + subDeploymentMBeanArray[i].getName() + " however there is no module in the application with that" + " URI or context-root.");
        }
    }

    public void prepare() throws DeploymentException {
        this.appCtx.setApplicationModules(this.createModules(this.appCtx));
        this.validateTargets();
    }

    public void validateRedeploy(DeploymentContext deploymentContext) throws DeploymentException {
        AppDDHolder appDDHolder = this.appCtx.getProposedPartialRedeployDDs();
        if (appDDHolder == null) {
            throw new AssertionError((Object)"Could not process proposed application deployment descriptors");
        }
        this.appCtx.setAdditionalModuleUris(this.getModuleUriMappings(appDDHolder));
    }

    private Map getModuleUriMappings(AppDDHolder appDDHolder) throws DeploymentException {
        HashMap<String, String> hashMap = Collections.EMPTY_MAP;
        if (appDDHolder.getApplicationBean() == null) {
            return hashMap;
        }
        ModuleBean[] moduleBeanArray = appDDHolder.getApplicationBean().getModules();
        if (moduleBeanArray.length > 0) {
            hashMap = new HashMap<String, String>(moduleBeanArray.length);
        }
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            hashMap.put(EarUtils.getModuleURI(moduleBeanArray[i]), EarUtils.reallyGetModuleURI(moduleBeanArray[i]));
        }
        if (appDDHolder.getWLApplicationBean() == null) {
            return hashMap;
        }
        WeblogicModuleBean[] weblogicModuleBeanArray = appDDHolder.getWLApplicationBean().getModules();
        for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
            String string = this.getModuleId(weblogicModuleBeanArray[i]);
            String string2 = this.getModuleURI(weblogicModuleBeanArray[i]);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private Module[] createModules(FlowContext flowContext) throws DeploymentException {
        ArrayList<Module> arrayList = new ArrayList<Module>();
        ModulesCreator modulesCreator = new CustomModulesCreator();
        Module[] moduleArray = modulesCreator.create(flowContext);
        arrayList.addAll(Arrays.asList(moduleArray));
        modulesCreator = new WebLogicModulesCreator();
        Module[] moduleArray2 = modulesCreator.create(flowContext);
        arrayList.addAll(Arrays.asList(moduleArray2));
        modulesCreator = new JeeModulesCreator();
        Module[] moduleArray3 = modulesCreator.create(flowContext);
        arrayList.addAll(Arrays.asList(moduleArray3));
        modulesCreator = new WebLogicExtensionModulesCreator();
        Module[] moduleArray4 = modulesCreator.create(flowContext);
        arrayList.addAll(Arrays.asList(moduleArray4));
        return this.createWrappedModules(arrayList);
    }

    private Module createModuleFromFactories(ModuleBean moduleBean) throws DeploymentException {
        Iterator<ModuleFactory> iterator = afm.getModuleFactories();
        while (iterator.hasNext()) {
            ModuleFactory moduleFactory = iterator.next();
            Module module = moduleFactory.createModule(moduleBean);
            if (module == null) continue;
            return this.createAndAddScopedCustomModules(module);
        }
        throw new DeploymentException("Unable to create module " + EarUtils.getModuleURI(moduleBean));
    }

    private Module createModuleFromFactories(WeblogicModuleBean weblogicModuleBean) throws DeploymentException {
        Iterator<WeblogicModuleFactory> iterator = afm.getWeblogicModuleFactories();
        while (iterator.hasNext()) {
            WeblogicModuleFactory weblogicModuleFactory = iterator.next();
            Module module = weblogicModuleFactory.createModule(weblogicModuleBean);
            if (module == null) continue;
            return module;
        }
        throw new DeploymentException("Unable to find module for " + weblogicModuleBean.getClass().getName());
    }

    public void start(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = new Module[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ModuleBean moduleBean = this.findStandardModuleDescriptor(stringArray[i]);
            if (moduleBean != null) {
                moduleArray[i] = this.createModuleFromFactories(moduleBean);
                continue;
            }
            WeblogicModuleBean weblogicModuleBean = this.findWLSModuleDescriptor(stringArray[i]);
            if (weblogicModuleBean != null) {
                moduleArray[i] = this.createModuleFromFactories(weblogicModuleBean);
                continue;
            }
            throw new ModuleNotFoundException("Trying to start uri " + stringArray[i] + " which does not currently exist in the application " + "and was not declared in the META-INF/application.xml or " + "META-INF/weblogic-application.xml.  If you were attempting " + "to redeploy a web module, please ensure you specified the " + "context-root rather than the web-uri.");
        }
        this.appCtx.setStartingModules(this.createWrappedModules(Arrays.asList(moduleArray)));
    }

    private ModuleBean findStandardModuleDescriptor(String string) {
        return this.findModuleDescriptor(this.appCtx.getApplicationDD().getModules(), string);
    }

    private WeblogicModuleBean findWLSModuleDescriptor(String string) {
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean != null) {
            return this.findModuleDescriptor(weblogicApplicationBean.getModules(), string);
        }
        return null;
    }

    private ModuleBean findModuleDescriptor(ModuleBean[] moduleBeanArray, String string) {
        if (moduleBeanArray == null) {
            return null;
        }
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            if (!EarUtils.getModuleURI(moduleBeanArray[i]).equals(string)) continue;
            return moduleBeanArray[i];
        }
        return null;
    }

    private WeblogicModuleBean findModuleDescriptor(WeblogicModuleBean[] weblogicModuleBeanArray, String string) {
        if (weblogicModuleBeanArray == null) {
            return null;
        }
        for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
            if (!this.getModuleId(weblogicModuleBeanArray[i]).equals(string)) continue;
            return weblogicModuleBeanArray[i];
        }
        return null;
    }

    private String getModuleId(WeblogicModuleBean weblogicModuleBean) {
        if (WebLogicModuleType.MODULETYPE_JDBC.equalsIgnoreCase(weblogicModuleBean.getType()) && weblogicModuleBean.getName() != null) {
            return weblogicModuleBean.getName();
        }
        return this.getModuleURI(weblogicModuleBean);
    }

    private String getModuleURI(WeblogicModuleBean weblogicModuleBean) {
        String string = weblogicModuleBean.getPath();
        if (string == null) {
            throw new AssertionError((Object)"WeblogicModuleBean contains no module URI");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module createAndAddScopedCustomModules(Module module) throws DeploymentException {
        ScopedModuleDriver scopedModuleDriver;
        if (!(module instanceof ParentModule)) {
            return module;
        }
        String string = ((ParentModule)((Object)module)).getDescriptorURI();
        ModuleBean moduleBean = this.findStandardModuleDescriptor(module.getId());
        if (moduleBean == null) {
            return module;
        }
        String string2 = EarUtils.reallyGetModuleURI(moduleBean);
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File[])this.appCtx.getEar().getModuleRoots(string2));
            scopedModuleDriver = new ScopedModuleDriver(module, this.appCtx, string2, virtualJarFile, string);
        }
        catch (IOException iOException) {
            Module module2;
            try {
                module2 = module;
            }
            catch (Throwable throwable) {
                IOUtils.forceClose(virtualJarFile);
                throw throwable;
            }
            IOUtils.forceClose(virtualJarFile);
            return module2;
        }
        IOUtils.forceClose(virtualJarFile);
        return scopedModuleDriver;
    }
}

