/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.application.CustomModuleFactory;
import weblogic.application.Module;
import weblogic.application.internal.CustomModuleContextImpl;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.ModuleProviderBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.management.DeploymentException;
import weblogic.utils.classloaders.GenericClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CustomModuleHelper {
    public static Map<String, CustomModuleFactory> initFactories(WeblogicExtensionBean weblogicExtensionBean, GenericClassLoader genericClassLoader) throws DeploymentException {
        return CustomModuleHelper.initFactories(weblogicExtensionBean, genericClassLoader, null, null);
    }

    public static Map<String, CustomModuleFactory> initFactories(WeblogicExtensionBean weblogicExtensionBean, GenericClassLoader genericClassLoader, String string, String string2) throws DeploymentException {
        if (weblogicExtensionBean == null) {
            return null;
        }
        ModuleProviderBean[] moduleProviderBeanArray = weblogicExtensionBean.getModuleProviders();
        if (moduleProviderBeanArray == null || moduleProviderBeanArray.length == 0) {
            return null;
        }
        HashMap<String, CustomModuleFactory> hashMap = new HashMap<String, CustomModuleFactory>(moduleProviderBeanArray.length);
        for (int i = 0; i < moduleProviderBeanArray.length; ++i) {
            CustomModuleFactory customModuleFactory = CustomModuleHelper.loadModuleFactory(moduleProviderBeanArray[i].getModuleFactoryClassName(), genericClassLoader);
            customModuleFactory.init(new CustomModuleContextImpl(moduleProviderBeanArray[i], string, string2));
            hashMap.put(moduleProviderBeanArray[i].getName(), customModuleFactory);
        }
        return hashMap;
    }

    private static CustomModuleFactory loadModuleFactory(String string, GenericClassLoader genericClassLoader) throws DeploymentException {
        try {
            Class<?> clazz = Class.forName(string, false, (ClassLoader)genericClassLoader);
            if (!CustomModuleFactory.class.isAssignableFrom(clazz)) {
                throw new DeploymentException("Your module-provider's module-factory-class " + string + " does not implement " + "weblogic.application.CustomModuleFactory");
            }
            return (CustomModuleFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException("Unable to load your custom module provider's module-factory-class " + string);
        }
        catch (InstantiationException instantiationException) {
            throw new DeploymentException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeploymentException(illegalAccessException);
        }
    }

    public static Module[] createScopedCustomModules(Module module, String string, WeblogicExtensionBean weblogicExtensionBean, GenericClassLoader genericClassLoader) throws DeploymentException {
        Map<String, CustomModuleFactory> map = CustomModuleHelper.initFactories(weblogicExtensionBean, genericClassLoader, module.getId(), string);
        ArrayList<Module> arrayList = new ArrayList<Module>();
        CustomModuleHelper.createCustomModules(weblogicExtensionBean.getCustomModules(), arrayList, map);
        return arrayList.toArray(new Module[arrayList.size()]);
    }

    public static void createCustomModules(CustomModuleBean[] customModuleBeanArray, List<Module> list, Map<String, CustomModuleFactory> map) throws DeploymentException {
        if (customModuleBeanArray == null || customModuleBeanArray.length == 0) {
            return;
        }
        for (int i = 0; i < customModuleBeanArray.length; ++i) {
            CustomModuleFactory customModuleFactory = map.get(customModuleBeanArray[i].getProviderName());
            if (customModuleFactory == null) {
                throw new DeploymentException("The custom module with the uri " + customModuleBeanArray[i].getUri() + " specified a provider-name of " + customModuleBeanArray[i].getProviderName() + ". However, there was no module-provider " + "with this name in your weblogic-extension.xml.");
            }
            Module module = customModuleFactory.createModule(customModuleBeanArray[i]);
            list.add(module);
        }
    }
}

