/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ConcurrentModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.ModuleWrapper;
import weblogic.application.UpdateListener;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.internal.flow.PartialRedeployUpdateListener;
import weblogic.application.utils.StateChange;
import weblogic.application.utils.StateChangeException;
import weblogic.application.utils.StateMachineDriver;
import weblogic.j2ee.J2EELogger;
import weblogic.management.DeploymentException;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.StackTraceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeploymentCallbackFlow
extends BaseFlow {
    private final StateMachineDriver driver = new StateMachineDriver();
    private static final boolean ENABLE_PREPARE_IN_PARALLEL = Boolean.getBoolean("weblogic.application.EnableDeployInParallel");
    private static final StateChange prepareStateChange = new StateChange(){

        public String toString() {
            return "prepare";
        }

        public void next(Object object) throws Exception {
            ((Module)object).prepare();
        }

        public void previous(Object object) throws Exception {
            ((Module)object).unprepare();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            BaseFlow.log("Ignoring unprepare errors " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };
    private static final StateChange activateStateChange = new StateChange(){

        public String toString() {
            return "activate";
        }

        public void next(Object object) throws Exception {
            ((Module)object).activate();
        }

        public void previous(Object object) throws Exception {
            ((Module)object).deactivate();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            BaseFlow.log("Ignoring deactivate errors " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };
    private static final StateChange removeStateChange = new StateChange(){

        public String toString() {
            return "remove";
        }

        public void next(Object object) throws Exception {
            throw new AssertionError((Object)"someone is transitioning up to remove!");
        }

        public void previous(Object object) throws Exception {
            ((Module)object).remove();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            BaseFlow.log("Ignoring remove errors " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };
    private static final StateChange adminToProductionChange = new StateChange(){

        public String toString() {
            return "adminToProd";
        }

        public void next(Object object) throws Exception {
            ((Module)object).adminToProduction();
        }

        public void previous(Object object) throws Exception {
            ((Module)object).forceProductionToAdmin();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            BaseFlow.log("Ignoring errors while forcing to admin mode " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };
    private static final StateChange prepareUpdateChange = new StateChange(){

        public String toString() {
            return "prepareUpdate";
        }

        public void next(Object object) throws Exception {
            PendingUpdate pendingUpdate = (PendingUpdate)object;
            pendingUpdate.listener.prepareUpdate(pendingUpdate.uri);
        }

        public void previous(Object object) throws Exception {
            PendingUpdate pendingUpdate = (PendingUpdate)object;
            pendingUpdate.listener.rollbackUpdate(pendingUpdate.uri);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            BaseFlow.log("Ignoring errors while rolling back update " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };

    public DeploymentCallbackFlow(FlowContext flowContext) {
        super(flowContext);
    }

    @Override
    public void prepare() throws DeploymentException {
        this.prepare(this.appCtx.getApplicationModules());
        this.appCtx.addUpdateListener(new PartialRedeployUpdateListener(this.appCtx));
    }

    private boolean isConcurrent(Module module) {
        return module instanceof ConcurrentModule && ((ConcurrentModule)((Object)module)).isParallelEnabled();
    }

    private boolean inInSamePartition(Module module, Module module2) {
        return !(this.isConcurrent(module) ^ this.isConcurrent(module2));
    }

    public List<Module[]> partitionModules(Module[] moduleArray) {
        Module[] moduleArray2 = new Module[moduleArray.length];
        for (int i = 0; i < moduleArray.length; ++i) {
            Module module = moduleArray[i];
            if (module instanceof ModuleWrapper) {
                module = ((ModuleWrapper)module).unwrap();
            }
            moduleArray2[i] = module;
        }
        ArrayList<Module[]> arrayList = new ArrayList<Module[]>();
        if (moduleArray != null && moduleArray.length > 0) {
            Module[] moduleArray3;
            int n;
            int n2 = 0;
            boolean bl = true;
            for (n = 0; n < moduleArray2.length; ++n) {
                if (this.inInSamePartition(moduleArray2[n2], moduleArray2[n])) continue;
                if (bl) {
                    bl = false;
                    if (this.isConcurrent(moduleArray2[n2])) {
                        arrayList.add(new Module[0]);
                    }
                }
                moduleArray3 = new Module[n - n2];
                System.arraycopy(moduleArray, n2, moduleArray3, 0, n - n2);
                arrayList.add(moduleArray3);
                n2 = n;
            }
            if (bl) {
                bl = false;
                if (this.isConcurrent(moduleArray2[n2])) {
                    arrayList.add(new Module[0]);
                }
            }
            moduleArray3 = new Module[n - n2];
            System.arraycopy(moduleArray, n2, moduleArray3, 0, n - n2);
            arrayList.add(moduleArray3);
        }
        return arrayList;
    }

    private void prepare(Module[] moduleArray) throws DeploymentException {
        try {
            if (ENABLE_PREPARE_IN_PARALLEL) {
                int n;
                boolean bl;
                List<Module[]> list = this.partitionModules(moduleArray);
                boolean bl2 = bl = list.get(0).length == 0;
                for (int i = n = bl ? 1 : 0; i < list.size(); ++i) {
                    Object[] objectArray = list.get(i);
                    if (bl2) {
                        this.driver.nextStateInParallel(prepareStateChange, objectArray);
                    } else {
                        this.driver.nextState(prepareStateChange, objectArray);
                    }
                    bl2 = !bl2;
                }
            } else {
                this.driver.nextState(prepareStateChange, moduleArray);
            }
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    @Override
    public void activate() throws DeploymentException {
        this.activate(this.appCtx.getApplicationModules());
    }

    private void activate(Module[] moduleArray) throws DeploymentException {
        try {
            this.driver.nextState(activateStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    @Override
    public void deactivate() throws DeploymentException {
        this.deactivate(this.appCtx.getApplicationModules());
    }

    private void deactivate(Module[] moduleArray) throws DeploymentException {
        try {
            this.driver.previousState(activateStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    @Override
    public void unprepare() throws DeploymentException {
        this.unprepare(this.appCtx.getApplicationModules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void unprepare(Module[] moduleArray) throws DeploymentException {
        try {
            try {
                this.driver.previousState(prepareStateChange, moduleArray);
            }
            catch (StateChangeException stateChangeException) {
                this.throwAppException(stateChangeException.getCause());
                Object var4_3 = null;
                DeploymentCallbackFlow.invokeStaticMethodEasy(ResourceBundle.class, "clearCache", new Class[]{ClassLoader.class}, new Object[]{this.appCtx.getAppClassLoader()});
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            DeploymentCallbackFlow.invokeStaticMethodEasy(ResourceBundle.class, "clearCache", new Class[]{ClassLoader.class}, new Object[]{this.appCtx.getAppClassLoader()});
            throw throwable;
        }
        DeploymentCallbackFlow.invokeStaticMethodEasy(ResourceBundle.class, "clearCache", new Class[]{ClassLoader.class}, new Object[]{this.appCtx.getAppClassLoader()});
    }

    public static void invokeStaticMethodEasy(Class<?> clazz, String string, Class<?>[] classArray, Object[] objectArray) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.invoke(null, objectArray);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    @Override
    public void remove() throws DeploymentException {
        try {
            this.driver.previousState(removeStateChange, this.appCtx.getApplicationModules());
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    @Override
    public void start(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getStartingModules();
        try {
            this.prepare(moduleArray);
            try {
                this.activate(moduleArray);
            }
            catch (Throwable throwable) {
                try {
                    this.unprepare(moduleArray);
                }
                catch (DeploymentException deploymentException) {
                    J2EELogger.logIgnoringUndeploymentError((Throwable)((Object)deploymentException));
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            try {
                this.destroy(moduleArray);
            }
            catch (Throwable throwable2) {
                J2EELogger.logIgnoringUndeploymentError((Throwable)throwable2);
            }
            this.throwAppException(throwable);
        }
    }

    private void destroy(Module[] moduleArray) throws DeploymentException {
        ErrorCollectionException errorCollectionException = null;
        int n = moduleArray.length;
        for (int i = n - 1; i >= 0; --i) {
            try {
                moduleArray[i].destroy(this.appCtx);
                continue;
            }
            catch (Throwable throwable) {
                if (errorCollectionException == null) {
                    errorCollectionException = new ErrorCollectionException();
                }
                errorCollectionException.addError(throwable);
            }
        }
        if (errorCollectionException != null) {
            this.throwAppException((Throwable)errorCollectionException);
        }
    }

    @Override
    public void stop(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getStoppingModules();
        try {
            this.deactivate(moduleArray);
        }
        catch (DeploymentException deploymentException) {
            this.log("Ignoring deactivate error ", (Throwable)((Object)deploymentException));
        }
        try {
            this.unprepare(moduleArray);
        }
        catch (DeploymentException deploymentException) {
            this.log("Ignoring unprepare error ", (Throwable)((Object)deploymentException));
        }
    }

    private void addPendingUpdates(List list, String string) throws DeploymentException {
        Iterator iterator = this.appCtx.getUpdateListeners().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            UpdateListener updateListener = (UpdateListener)e;
            if (!updateListener.acceptURI(string)) continue;
            bl = true;
            list.add(new PendingUpdate(string, updateListener));
        }
        if (!bl) {
            DeploymentCallbackFlow.log("No UpdateListener found or none of the found UpdateListeners accepts URI");
            throw new DeploymentException("\n The application " + this.appCtx.getApplicationId() + " cannot have the resource " + string + " updated dynamically. Either:\n" + "1.) The resource does not exist. \n" + " or \n" + "2) The resource cannot be changed dynamically. \n" + "Please ensure the resource uri is correct," + " and redeploy the entire application for this change to" + " take effect.");
        }
    }

    private PendingUpdate[] makePendingUpdates(String[] stringArray) throws DeploymentException {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            this.addPendingUpdates(arrayList, stringArray[i]);
        }
        return arrayList.toArray(new PendingUpdate[arrayList.size()]);
    }

    @Override
    public void prepareUpdate(String[] stringArray) throws DeploymentException {
        Object[] objectArray = this.makePendingUpdates(stringArray);
        try {
            this.driver.nextState(prepareUpdateChange, objectArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    @Override
    public void rollbackUpdate(String[] stringArray) throws DeploymentException {
        Object[] objectArray = this.makePendingUpdates(stringArray);
        try {
            this.driver.previousState(prepareUpdateChange, objectArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activateUpdate(String[] stringArray) throws DeploymentException {
        PendingUpdate[] pendingUpdateArray = this.makePendingUpdates(stringArray);
        try {
            for (int i = 0; i < pendingUpdateArray.length; ++i) {
                PendingUpdate pendingUpdate = pendingUpdateArray[i];
                try {
                    pendingUpdate.listener.activateUpdate(pendingUpdate.uri);
                    continue;
                }
                catch (ModuleException moduleException) {
                    throw new DeploymentException((Throwable)((Object)moduleException));
                }
            }
            Object var7_6 = null;
            pendingUpdateArray = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            pendingUpdateArray = null;
            throw throwable;
        }
    }

    @Override
    public void adminToProduction() throws DeploymentException {
        this.adminToProduction(this.appCtx.getApplicationModules());
    }

    public void adminToProduction(Module[] moduleArray) throws DeploymentException {
        try {
            this.driver.nextState(adminToProductionChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    private void forceProductionToAdmin(Module[] moduleArray) throws DeploymentException {
        try {
            this.driver.previousState(adminToProductionChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    @Override
    public void forceProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
        this.forceProductionToAdmin(this.appCtx.getApplicationModules());
    }

    @Override
    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
        try {
            this.driver.previousState(new GracefulProductionToAdminChange(adminModeCompletionBarrier), this.appCtx.getApplicationModules());
        }
        catch (StateChangeException stateChangeException) {
            this.throwAppException(stateChangeException.getCause());
        }
    }

    private static final class GracefulProductionToAdminChange
    implements StateChange {
        private final AdminModeCompletionBarrier barrier;

        GracefulProductionToAdminChange(AdminModeCompletionBarrier adminModeCompletionBarrier) {
            this.barrier = adminModeCompletionBarrier;
        }

        public void next(Object object) throws Exception {
            throw new AssertionError((Object)"GracefulProductionToAdminChange.next");
        }

        public void previous(Object object) throws Exception {
            ((Module)object).gracefulProductionToAdmin(this.barrier);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            BaseFlow.log("Ignoring errors while bringing to admin mode " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    }

    private static class PendingUpdate {
        private final String uri;
        private final UpdateListener listener;

        PendingUpdate(String string, UpdateListener updateListener) {
            this.uri = string;
            this.listener = updateListener;
        }
    }
}

