/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.io.File;
import java.security.AccessController;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.PathUtils;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.FileUtils;

public final class DescriptorCacheDirFlow
extends BaseFlow {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();

    public DescriptorCacheDirFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() {
        this.appCtx.setDescriptorCacheDir(PathUtils.generateDescriptorCacheDir(serverName, this.appCtx.getApplicationId(), this.appCtx.isInternalApp()));
    }

    public void remove() {
        File file = this.appCtx.getDescriptorCacheDir();
        if (file != null) {
            FileUtils.remove((File)file);
        }
    }
}

