/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.application.internal.AppDDHolder;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.deploy.container.DeploymentContext;
import weblogic.descriptor.Descriptor;
import weblogic.descriptor.DescriptorBean;
import weblogic.descriptor.DescriptorManager;
import weblogic.descriptor.DescriptorUpdateFailedException;
import weblogic.descriptor.DescriptorUpdateRejectedException;
import weblogic.j2ee.descriptor.wl.DeploymentPlanBean;
import weblogic.j2ee.descriptor.wl.ModuleDescriptorBean;
import weblogic.j2ee.descriptor.wl.ModuleOverrideBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.utils.jars.VirtualJarFile;

public final class DescriptorParsingFlow
extends BaseFlow {
    private static DebugCategory debugger = Debug.getCategory((String)"weblogic.application.DebugDescriptorParsing");

    public DescriptorParsingFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        this.parseDDs();
        if (this.appCtx.getWLApplicationDD() != null) {
            this.appCtx.addUpdateListener(new WLAppUpdateListener(this.appCtx));
        } else {
            this.appCtx.addUpdateListener(new NullListener());
        }
    }

    public void start(String[] stringArray) throws DeploymentException {
        this.parseDDs();
    }

    private String getApplicationNameForPlan(String string, String string2, DeploymentPlanBean deploymentPlanBean) {
        if (deploymentPlanBean != null && deploymentPlanBean.findModuleOverride(string) != null) {
            ModuleOverrideBean moduleOverrideBean = deploymentPlanBean.findModuleOverride(string2);
            if (moduleOverrideBean == null) {
                return string;
            }
            boolean bl = false;
            ModuleDescriptorBean[] moduleDescriptorBeanArray = moduleOverrideBean.getModuleDescriptors();
            if (moduleDescriptorBeanArray != null) {
                for (int i = 0; i < moduleDescriptorBeanArray.length && !bl; ++i) {
                    if (moduleDescriptorBeanArray[i].getVariableAssignments() == null || moduleDescriptorBeanArray[i].getVariableAssignments().length <= 0) continue;
                    bl = true;
                }
            }
            if (!bl) {
                return string;
            }
        }
        return string2;
    }

    private ApplicationDescriptor createAppDescriptor() throws ModuleException {
        ApplicationDescriptor applicationDescriptor;
        if (debugger.isEnabled()) {
            Debug.say((String)"Parsing application level descriptors");
        }
        VirtualJarFile virtualJarFile = null;
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        DeploymentPlanBean deploymentPlanBean = appDeploymentMBean.getDeploymentPlanDescriptor();
        String string = appDeploymentMBean.getAltDescriptorPath();
        String string2 = appDeploymentMBean.getAltWLSDescriptorPath();
        File file = null;
        File file2 = null;
        if (string != null) {
            file = new File(string);
        }
        if (string2 != null) {
            file2 = new File(string2);
        }
        try {
            if (debugger.isEnabled()) {
                Debug.say((String)("Making a choice between app name & file name for plan overrides: " + this.appCtx.getApplicationName() + ", " + this.appCtx.getApplicationFileName()));
            }
            virtualJarFile = this.appCtx.getApplicationFileManager().getVirtualJarFile();
            String string3 = this.getApplicationNameForPlan(this.appCtx.getApplicationName(), this.appCtx.getApplicationFileName(), deploymentPlanBean);
            if (debugger.isEnabled()) {
                Debug.say((String)("Plan override choice made: " + string3));
            }
            ApplicationDescriptor applicationDescriptor2 = new ApplicationDescriptor(file, file2, virtualJarFile, EarUtils.getConfigDir(this.appCtx), deploymentPlanBean, string3);
            if (debugger.isEnabled()) {
                this.say("Parsed descriptor", applicationDescriptor2);
            }
            applicationDescriptor = applicationDescriptor2;
        }
        catch (IOException iOException) {
            try {
                throw new ModuleException(iOException);
            }
            catch (Throwable throwable) {
                IOUtils.forceClose(virtualJarFile);
                throw throwable;
            }
        }
        IOUtils.forceClose(virtualJarFile);
        return applicationDescriptor;
    }

    public void validateRedeploy(DeploymentContext deploymentContext) throws DeploymentException {
        AppDDHolder appDDHolder = null;
        appDDHolder = this.parseDDs(this.createAppDescriptor());
        this.appCtx.setProposedPartialRedeployDDs(appDDHolder);
    }

    private void parseDDs() throws DeploymentException {
        ApplicationDescriptor applicationDescriptor = this.createAppDescriptor();
        try {
            this.appCtx.setApplicationDescriptor(applicationDescriptor);
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeploymentException(xMLStreamException);
        }
    }

    private AppDDHolder parseDDs(ApplicationDescriptor applicationDescriptor) throws DeploymentException {
        try {
            return new AppDDHolder(applicationDescriptor.getApplicationDescriptor(), applicationDescriptor.getWeblogicApplicationDescriptor(), applicationDescriptor.getWeblogicExtensionDescriptor());
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new DeploymentException(xMLStreamException);
        }
    }

    private void say(String string, ApplicationDescriptor applicationDescriptor) {
        try {
            ByteArrayOutputStream byteArrayOutputStream;
            DescriptorBean descriptorBean = (DescriptorBean)applicationDescriptor.getApplicationDescriptor();
            DescriptorBean descriptorBean2 = (DescriptorBean)applicationDescriptor.getWeblogicApplicationDescriptor();
            DescriptorBean descriptorBean3 = (DescriptorBean)applicationDescriptor.getWeblogicExtensionDescriptor();
            if (descriptorBean != null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                new DescriptorManager().writeDescriptorAsXML(descriptorBean.getDescriptor(), (OutputStream)byteArrayOutputStream);
                Debug.say((String)(string + "\n" + byteArrayOutputStream.toString()));
                byteArrayOutputStream.close();
            }
            if (descriptorBean2 != null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                new DescriptorManager().writeDescriptorAsXML(descriptorBean2.getDescriptor(), (OutputStream)byteArrayOutputStream);
                Debug.say((String)(string + "\n" + byteArrayOutputStream.toString()));
                byteArrayOutputStream.close();
            }
            if (descriptorBean3 != null) {
                byteArrayOutputStream = new ByteArrayOutputStream();
                new DescriptorManager().writeDescriptorAsXML(descriptorBean3.getDescriptor(), (OutputStream)byteArrayOutputStream);
                Debug.say((String)(string + "\n" + byteArrayOutputStream.toString()));
                byteArrayOutputStream.close();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
    }

    private static class NullListener
    implements UpdateListener {
        private NullListener() {
        }

        public boolean acceptURI(String string) {
            return "META-INF/weblogic-application.xml".equals(string);
        }

        public void prepareUpdate(String string) {
        }

        public void activateUpdate(String string) {
        }

        public void rollbackUpdate(String string) {
        }
    }

    private class WLAppUpdateListener
    implements UpdateListener {
        private static final boolean DEBUG = false;
        private final ApplicationContextInternal appCtx;
        private Descriptor proposedDescriptor;
        private Descriptor currentDescriptor;

        private WLAppUpdateListener(ApplicationContextInternal applicationContextInternal) {
            this.appCtx = applicationContextInternal;
            WeblogicApplicationBean weblogicApplicationBean = applicationContextInternal.getWLApplicationDD();
            this.currentDescriptor = ((DescriptorBean)weblogicApplicationBean).getDescriptor();
        }

        private WeblogicApplicationBean parseNewWLDD() throws ModuleException {
            ApplicationDescriptor applicationDescriptor = DescriptorParsingFlow.this.createAppDescriptor();
            try {
                return applicationDescriptor.getWeblogicApplicationDescriptor();
            }
            catch (IOException iOException) {
                throw new ModuleException(iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new ModuleException(xMLStreamException);
            }
        }

        public boolean acceptURI(String string) {
            return "META-INF/weblogic-application.xml".equals(string);
        }

        public void prepareUpdate(String string) throws ModuleException {
            WeblogicApplicationBean weblogicApplicationBean = this.parseNewWLDD();
            this.proposedDescriptor = ((DescriptorBean)weblogicApplicationBean).getDescriptor();
            try {
                this.currentDescriptor.prepareUpdate(this.proposedDescriptor);
            }
            catch (DescriptorUpdateRejectedException descriptorUpdateRejectedException) {
                throw new ModuleException(descriptorUpdateRejectedException);
            }
        }

        public void activateUpdate(String string) throws ModuleException {
            try {
                this.currentDescriptor.activateUpdate();
            }
            catch (DescriptorUpdateFailedException descriptorUpdateFailedException) {
                throw new ModuleException(descriptorUpdateFailedException);
            }
            finally {
                this.proposedDescriptor = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollbackUpdate(String string) {
            try {
                this.currentDescriptor.rollbackUpdate();
            }
            finally {
                this.proposedDescriptor = null;
            }
        }
    }
}

