/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFileManager;
import weblogic.application.SplitDirectoryInfo;
import weblogic.application.internal.AppClassLoaderManagerImpl;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.io.Ear;
import weblogic.application.io.JarCopyFilter;
import weblogic.application.utils.AppFileOverrideUtils;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.application.utils.PathUtils;
import weblogic.management.DeploymentException;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.spring.monitoring.instrumentation.SpringInstrumentationUtils;
import weblogic.utils.classloaders.GenericClassLoader;

public final class EarClassLoaderFlow
extends BaseFlow {
    private static final AppClassLoaderManagerImpl appClassLoaderManager = (AppClassLoaderManagerImpl)AppClassLoaderManager.getAppClassLoaderManager();
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();

    public EarClassLoaderFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        try {
            File file = PathUtils.getAppTempDir(serverName, ApplicationVersionUtils.replaceDelimiter(this.appCtx.getApplicationId(), '_'));
            Ear ear = this.createEar(file);
            this.appCtx.setEar(ear);
            AppFileOverrideUtils.addFinderIfRequired(this.appCtx.getAppDeploymentMBean(), this.appCtx.getAppClassLoader());
            this.appCtx.getAppClassLoader().addClassFinder(ear.getClassFinder());
            SpringInstrumentationUtils.addSpringInstrumentor((GenericClassLoader)this.appCtx.getAppClassLoader());
        }
        catch (IOException iOException) {
            throw new DeploymentException(iOException);
        }
    }

    public void unprepare() throws DeploymentException {
        appClassLoaderManager.removeApplicationLoader(this.appCtx.getApplicationId());
        GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
        genericClassLoader.close();
    }

    public void remove() {
        Ear ear = this.appCtx.getEar();
        if (ear != null) {
            ear.remove();
        }
    }

    private Ear createEar(File file) throws IOException {
        File file2 = new File(this.appCtx.getStagingPath());
        if (!file2.exists()) {
            throw new IOException("Could not read application at " + file2.getAbsolutePath());
        }
        if (!file2.isDirectory()) {
            return this.archivedEar(file, file2);
        }
        File file3 = new File(file2, ".beabuild.txt");
        if (file3.exists()) {
            this.appCtx.setSplitDir();
            return this.splitDirectory(file, file2, file3);
        }
        return this.explodedEAR(file, file2);
    }

    private Ear archivedEar(File file, File file2) throws IOException {
        this.appCtx.setApplicationPaths(new File[]{file});
        this.appCtx.setApplicationFileManager(ApplicationFileManager.newInstance(file));
        return new Ear(this.appCtx.getApplicationId(), file, file2);
    }

    private Ear splitDirectory(File file, File file2, File file3) throws IOException {
        SplitDirectoryInfo splitDirectoryInfo = new SplitDirectoryInfo(file2, file3);
        this.appCtx.setApplicationPaths(splitDirectoryInfo.getRootDirectories());
        this.appCtx.setApplicationFileManager(ApplicationFileManager.newInstance(splitDirectoryInfo));
        this.appCtx.setSplitDirectoryInfo(splitDirectoryInfo);
        return new Ear(this.appCtx.getApplicationId(), file, splitDirectoryInfo);
    }

    private Ear explodedEAR(File file, File file2) throws IOException {
        this.appCtx.setApplicationPaths(new File[]{file2});
        this.appCtx.setApplicationFileManager(ApplicationFileManager.newInstance(file2));
        if (this.appCtx.isInternalApp()) {
            return new Ear(this.appCtx.getApplicationId(), file, new File[]{file2}, JarCopyFilter.NOCOPY_FILTER);
        }
        return new Ear(this.appCtx.getApplicationId(), file, new File[]{file2});
    }
}

