/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.HashMap;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.ejb.spi.EJBCache;
import weblogic.ejb.spi.EJBCacheFactory;
import weblogic.ejb.spi.QueryCache;
import weblogic.ejb.spi.ReInitializableCache;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.wl.ApplicationEntityCacheBean;
import weblogic.j2ee.descriptor.wl.EjbBean;
import weblogic.j2ee.descriptor.wl.MaxCacheSizeBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;

public final class HeadEJBCacheFlow
extends BaseFlow {
    public HeadEJBCacheFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        this.setupEJB();
    }

    public void unprepare() {
        this.unSetupEJB();
    }

    private boolean isExclusiveCache(ApplicationEntityCacheBean applicationEntityCacheBean) {
        return applicationEntityCacheBean.getCachingStrategy().equalsIgnoreCase("Exclusive");
    }

    private boolean isMultiVersionCache(ApplicationEntityCacheBean applicationEntityCacheBean) {
        return applicationEntityCacheBean.getCachingStrategy().equalsIgnoreCase("MultiVersion");
    }

    private void setupEJB() throws DeploymentException {
        ApplicationEntityCacheBean applicationEntityCacheBean;
        WeblogicApplicationBean weblogicApplicationBean = null;
        EjbBean ejbBean = null;
        ApplicationEntityCacheBean[] applicationEntityCacheBeanArray = null;
        HashMap<String, EJBCache> hashMap = new HashMap<String, EJBCache>();
        HashMap<String, QueryCache> hashMap2 = new HashMap<String, QueryCache>();
        this.appCtx.setEJBCacheMap(hashMap);
        this.appCtx.setEJBQueryCacheMap(hashMap2);
        weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean != null && (ejbBean = weblogicApplicationBean.getEjb()) != null) {
            applicationEntityCacheBeanArray = ejbBean.getEntityCaches();
            for (int i = 0; i < applicationEntityCacheBeanArray.length; ++i) {
                applicationEntityCacheBean = applicationEntityCacheBeanArray[i];
                MaxCacheSizeBean maxCacheSizeBean = applicationEntityCacheBean.getMaxCacheSize();
                boolean bl = true;
                int n = -1;
                long l = -1L;
                if (maxCacheSizeBean == null) {
                    n = applicationEntityCacheBean.getMaxBeansInCache();
                } else {
                    bl = false;
                    l = maxCacheSizeBean.getBytes() == -1 ? (long)maxCacheSizeBean.getMegabytes() * 0x100000L : (long)maxCacheSizeBean.getBytes();
                }
                EJBCache eJBCache = null;
                if (this.isExclusiveCache(applicationEntityCacheBean)) {
                    eJBCache = bl ? EJBCacheFactory.createNRUCache(applicationEntityCacheBean.getEntityCacheName(), n) : EJBCacheFactory.createNRUCache(applicationEntityCacheBean.getEntityCacheName(), l);
                } else if (this.isMultiVersionCache(applicationEntityCacheBean)) {
                    eJBCache = bl ? EJBCacheFactory.createEntityCache(applicationEntityCacheBean.getEntityCacheName(), n) : EJBCacheFactory.createEntityCache(applicationEntityCacheBean.getEntityCacheName(), l);
                } else {
                    throw new AssertionError((Object)("illegal caching scheme: " + applicationEntityCacheBean.getCachingStrategy()));
                }
                hashMap.put(applicationEntityCacheBean.getEntityCacheName(), eJBCache);
                int n2 = applicationEntityCacheBean.getMaxQueriesInCache();
                hashMap2.put(applicationEntityCacheBean.getEntityCacheName(), EJBCacheFactory.createQueryCache(applicationEntityCacheBean.getEntityCacheName(), n2));
            }
        }
        J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
        applicationEntityCacheBean = hashMap.values().toArray(new ReInitializableCache[0]);
        j2EEApplicationRuntimeMBeanImpl.setApplicationCaches((ReInitializableCache[])applicationEntityCacheBean);
        try {
            j2EEApplicationRuntimeMBeanImpl.setQueryCacheRuntimes(hashMap2);
        }
        catch (ManagementException managementException) {
            throw new DeploymentException("Error setting up query-caching runtimes", managementException);
        }
        if (!hashMap.containsKey("ExclusiveCache")) {
            hashMap.put("ExclusiveCache", EJBCacheFactory.createNRUCache("ExclusiveCache", 1000));
        }
        if (!hashMap.containsKey("MultiVersionCache")) {
            hashMap.put("MultiVersionCache", EJBCacheFactory.createEntityCache("MultiVersionCache", 1000));
        }
    }

    private void unSetupEJB() {
        Map map;
        J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
        j2EEApplicationRuntimeMBeanImpl.setApplicationCaches(new ReInitializableCache[0]);
        Map map2 = this.appCtx.getEJBCacheMap();
        if (map2 != null) {
            map2.clear();
        }
        if ((map = this.appCtx.getEJBQueryCacheMap()) != null) {
            map.clear();
        }
    }
}

