/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginException;
import weblogic.application.ApplicationException;
import weblogic.application.ApplicationLifecycleEvent;
import weblogic.application.ApplicationLifecycleListener;
import weblogic.application.ApplicationVersionLifecycleListener;
import weblogic.application.event.ApplicationEventManager;
import weblogic.application.internal.Flow;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.BaseLifecycleFlow;
import weblogic.deploy.event.ApplicationVersionLifecycleListenerAdapter;
import weblogic.j2ee.J2EEApplicationService;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.ListenerBean;
import weblogic.j2ee.descriptor.wl.ShutdownBean;
import weblogic.j2ee.descriptor.wl.StartupBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.security.SubjectUtils;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrincipalAuthenticator;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;

public final class HeadLifecycleFlow
extends BaseLifecycleFlow
implements Flow {
    private static final ApplicationLifecycleListener[] EMPTY_LISTENERS = new ApplicationLifecycleListener[0];
    private PrincipalAuthenticator pa = null;

    public HeadLifecycleFlow(FlowContext flowContext) {
        super(flowContext);
    }

    private void addListenerJarToLoader(GenericClassLoader genericClassLoader, String string) throws DeploymentException {
        URL uRL = genericClassLoader.getResource(this.appCtx.getApplicationId() + "#" + string);
        if (uRL == null) {
            Loggable loggable = J2EELogger.logUnabletoFindLifecycleJarLoggable((String)this.appCtx.getApplicationId(), (String)string);
            throw new DeploymentException(loggable.getMessage());
        }
        genericClassLoader.addClassFinder((ClassFinder)new ClasspathClassFinder2(uRL.getFile()));
    }

    private Class createMainClass(String string, String string2) throws DeploymentException {
        GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
        if (string2 != null) {
            this.addListenerJarToLoader(genericClassLoader, string2);
        }
        BaseLifecycleFlow.CreateMainClassAction createMainClassAction = new BaseLifecycleFlow.CreateMainClassAction(genericClassLoader, string);
        return (Class)createMainClassAction.invoke();
    }

    private ApplicationLifecycleListener createNonVersionedListener(String string, String string2) throws DeploymentException {
        return (ApplicationLifecycleListener)this.createListener(string, string2, true);
    }

    private Object createListener(String string, String string2) throws DeploymentException {
        return this.createListener(string, string2, false);
    }

    private Object createListener(String string, String string2, boolean bl) throws DeploymentException {
        GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
        if (string2 != null) {
            this.addListenerJarToLoader(genericClassLoader, string2);
        }
        BaseLifecycleFlow.CreateListenerAction createListenerAction = new BaseLifecycleFlow.CreateListenerAction(genericClassLoader, string, bl);
        return createListenerAction.invoke();
    }

    private ApplicationLifecycleListener createStartupListener(String string, String string2) throws DeploymentException {
        return new MainListener(this.createMainClass(string, string2)){

            public void preStart(ApplicationLifecycleEvent applicationLifecycleEvent) throws ApplicationException {
                this.invokeMain();
            }
        };
    }

    private ApplicationLifecycleListener createShutdownListener(String string, String string2) throws DeploymentException {
        return new MainListener(this.createMainClass(string, string2)){

            public void postStop(ApplicationLifecycleEvent applicationLifecycleEvent) throws ApplicationException {
                this.invokeMain();
            }
        };
    }

    private ApplicationLifecycleListener[] createListeners() throws DeploymentException {
        Object[] objectArray;
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        List<ApplicationLifecycleListener> list = ApplicationEventManager.getInstance().createListeners(this.appCtx);
        List list2 = J2EEApplicationService.getApplicationLifecycleListeners();
        if (weblogicApplicationBean == null && list2.isEmpty()) {
            return list.size() == 0 ? EMPTY_LISTENERS : list.toArray(new ApplicationLifecycleListener[0]);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList.addAll(list2);
        if (weblogicApplicationBean != null) {
            ShutdownBean[] shutdownBeanArray;
            int n;
            Object object;
            objectArray = weblogicApplicationBean.getListeners();
            if (objectArray != null) {
                object = null;
                for (n = 0; n < objectArray.length; ++n) {
                    AuthenticatedSubject authenticatedSubject;
                    Object object2 = this.createListener(objectArray[n].getListenerClass(), objectArray[n].getListenerUri());
                    if (object2 instanceof ApplicationLifecycleListener) {
                        arrayList.add(object2);
                    } else if (object2 instanceof ApplicationVersionLifecycleListener) {
                        arrayList2.add(object2);
                    }
                    if (objectArray[n].getRunAsPrincipalName() == null || (authenticatedSubject = this.getRunAsIdentity(objectArray[n])) == null) continue;
                    if (object == null) {
                        object = new HashMap();
                    }
                    object.put(object2, authenticatedSubject);
                }
                this.appCtx.setAppListenerIdentityMappings((Map)(object != null ? object : Collections.EMPTY_MAP));
                if (arrayList2.size() > 0) {
                    ApplicationVersionLifecycleListener[] applicationVersionLifecycleListenerArray = new ApplicationVersionLifecycleListener[arrayList2.size()];
                    arrayList2.toArray(applicationVersionLifecycleListenerArray);
                    this.appCtx.setApplicationVersionListenerAdapter(new ApplicationVersionLifecycleListenerAdapter(this.appCtx.getApplicationId(), applicationVersionLifecycleListenerArray));
                }
            }
            if ((object = weblogicApplicationBean.getStartups()) != null) {
                for (n = 0; n < ((StartupBean[])object).length; ++n) {
                    arrayList.add(this.createStartupListener(object[n].getStartupClass(), object[n].getStartupUri()));
                }
            }
            if ((shutdownBeanArray = weblogicApplicationBean.getShutdowns()) != null) {
                for (int i = 0; i < shutdownBeanArray.length; ++i) {
                    arrayList.add(this.createShutdownListener(shutdownBeanArray[i].getShutdownClass(), shutdownBeanArray[i].getShutdownUri()));
                }
            }
        }
        arrayList.addAll(list);
        objectArray = new ApplicationLifecycleListener[arrayList.size()];
        return (ApplicationLifecycleListener[])arrayList.toArray(objectArray);
    }

    private AuthenticatedSubject getRunAsIdentity(ListenerBean listenerBean) throws DeploymentException {
        String string = listenerBean.getRunAsPrincipalName();
        AuthenticatedSubject authenticatedSubject = null;
        try {
            authenticatedSubject = this.getPrincipalAuthenticator().impersonateIdentity(string);
        }
        catch (LoginException loginException) {
            Loggable loggable = J2EELogger.logRunAsPrincipalNotFoundLoggable((String)this.appCtx.getApplicationId(), (String)listenerBean.getListenerClass(), (String)string);
            throw new DeploymentException(loggable.getMessage());
        }
        this.checkDeployUserPrivileges(listenerBean, authenticatedSubject);
        return authenticatedSubject;
    }

    private void checkDeployUserPrivileges(ListenerBean listenerBean, AuthenticatedSubject authenticatedSubject) throws DeploymentException {
        AuthenticatedSubject authenticatedSubject2;
        if (!(!SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject) || (authenticatedSubject2 = this.appCtx.getDeploymentInitiator()) == null || this.appCtx.isStaticDeploymentOperation() && SubjectUtils.isUserAnonymous((AuthenticatedSubject)authenticatedSubject2) || SubjectUtils.isUserAnAdministrator((AuthenticatedSubject)authenticatedSubject2))) {
            Loggable loggable = J2EELogger.logAttemptToBumpUpPrivilegesWithRunAsLoggable((String)this.appCtx.getApplicationId(), (String)listenerBean.getListenerClass(), (String)listenerBean.getRunAsPrincipalName());
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private PrincipalAuthenticator getPrincipalAuthenticator() {
        if (this.pa != null) {
            return this.pa;
        }
        String string = this.appCtx.getApplicationSecurityRealmName();
        if (string == null) {
            string = "weblogicDEFAULT";
        }
        this.pa = (PrincipalAuthenticator)SecurityServiceManager.getSecurityService((AuthenticatedSubject)KERNEL_ID, (String)string, (SecurityService.ServiceType)SecurityService.ServiceType.AUTHENTICATION);
        return this.pa;
    }

    public void prepare() throws DeploymentException {
        this.appCtx.setApplicationListeners(this.createListeners());
        this.preStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare() throws DeploymentException {
        try {
            this.postStop();
            Object var2_1 = null;
            this.appCtx.setApplicationListeners(null);
            this.appCtx.setApplicationVersionListenerAdapter(null);
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.appCtx.setApplicationListeners(null);
            this.appCtx.setApplicationVersionListenerAdapter(null);
            throw throwable;
        }
    }

    private static abstract class MainListener
    extends ApplicationLifecycleListener {
        private static final Class[] MAIN_SIGNATURE = new Class[]{String[].class};
        private static final Object[] MAIN_ARGS = new Object[]{new String[0]};
        private final Class mainClass;
        protected Method mainMethod;

        MainListener(Class clazz) throws DeploymentException {
            this.mainClass = clazz;
            try {
                this.mainMethod = clazz.getMethod("main", MAIN_SIGNATURE);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new DeploymentException(noSuchMethodException);
            }
        }

        protected void invokeMain() throws ApplicationException {
            try {
                this.mainMethod.invoke(null, MAIN_ARGS);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new AssertionError((Object)illegalArgumentException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable == null) {
                    throwable = invocationTargetException.getCause();
                }
                if (throwable == null) {
                    throwable = invocationTargetException;
                }
                throw new ApplicationException(throwable);
            }
        }
    }
}

