/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.ApplicationContextInternal;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.internal.Flow;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.library.LibraryManager;
import weblogic.application.library.LibraryReference;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.descriptor.wl.LibraryRefBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.DeploymentException;

public final class ImportLibrariesFlow
extends BaseFlow
implements Flow {
    private static final ApplicationFactoryManager afm = ApplicationFactoryManager.getApplicationFactoryManager();
    private LibraryManager mgr = null;

    public ImportLibrariesFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        LibraryReference[] libraryReferenceArray;
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean == null) {
            return;
        }
        LibraryRefBean[] libraryRefBeanArray = weblogicApplicationBean.getLibraryRefs();
        if (libraryRefBeanArray == null || libraryRefBeanArray.length == 0) {
            return;
        }
        try {
            libraryReferenceArray = LibraryLoggingUtils.initLibRefs(libraryRefBeanArray);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new DeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
        this.mgr = new LibraryManager(LibraryUtils.initAppReferencer(this.appCtx), libraryReferenceArray);
        this.appCtx.getLibraryManagerAggregate().setAppLevelLibraryManager(this.mgr);
        if (this.mgr.hasUnresolvedReferences()) {
            return;
        }
        try {
            LibraryUtils.importAppLibraries(this.mgr, this.appCtx, this.appCtx, true);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new DeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
        this.mgr.addReferences();
        this.appCtx.getRuntime().setLibraryRuntimes(this.mgr.getReferencedLibraryRuntimes());
    }

    public void unprepare() {
        if (this.mgr != null) {
            this.mgr.removeReferences();
        }
    }
}

