/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import com.bea.wls.redef.ClassRedefInitializationException;
import com.bea.wls.redef.ClassRedefinerFactory;
import com.bea.wls.redef.RedefiningClassLoader;
import com.bea.wls.redef.runtime.ClassRedefinitionRuntimeImpl;
import com.bea.wls.redef.runtime.ClassRedefinitionRuntimeMBean;
import java.security.AccessController;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.ApplicationContextImpl;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.j2ee.J2EEApplicationRuntimeMBeanImpl;
import weblogic.j2ee.descriptor.wl.FastSwapBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.management.DeploymentException;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;

public class InitFastSwapLoaderFlow
extends BaseFlow {
    private static final DebugLogger logger = DebugLogger.getDebugLogger((String)"DebugClassRedef");
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean PRODUCTION_MODE = ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().isProductionModeEnabled();

    public InitFastSwapLoaderFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        this.initLoader(this.appCtx.getWLApplicationDD());
    }

    public void initLoader(WeblogicApplicationBean weblogicApplicationBean) throws DeploymentException {
        if (PRODUCTION_MODE) {
            return;
        }
        if (weblogicApplicationBean == null) {
            return;
        }
        FastSwapBean fastSwapBean = weblogicApplicationBean.getFastSwap();
        if (fastSwapBean == null) {
            return;
        }
        boolean bl = fastSwapBean.isEnabled();
        int n = fastSwapBean.getRefreshInterval();
        if (logger.isDebugEnabled()) {
            logger.debug(" Enabled : " + bl + " Reload : " + n);
        }
        if (bl) {
            GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
            try {
                GenericClassLoader genericClassLoader2 = ClassRedefinerFactory.makeClassLoader((ClassFinder)genericClassLoader.getClassFinder(), (ClassLoader)genericClassLoader.getParent());
                genericClassLoader2.setAnnotation(genericClassLoader.getAnnotation());
                ((RedefiningClassLoader)genericClassLoader2).getRedefinitionRuntime().setRedefinitionTaskLimit(fastSwapBean.getRedefinitionTaskLimit());
                this.createRuntime(genericClassLoader2);
                if (logger.isDebugEnabled()) {
                    logger.debug(" Appclassloader reset to " + genericClassLoader2);
                }
                ((ApplicationContextImpl)this.appCtx).resetAppClassLoader(genericClassLoader2);
            }
            catch (ClassRedefInitializationException classRedefInitializationException) {
                throw new DeploymentException(classRedefInitializationException);
            }
        }
    }

    private void createRuntime(GenericClassLoader genericClassLoader) throws ClassRedefInitializationException {
        try {
            J2EEApplicationRuntimeMBeanImpl j2EEApplicationRuntimeMBeanImpl = this.appCtx.getRuntime();
            ClassRedefinitionRuntimeImpl classRedefinitionRuntimeImpl = new ClassRedefinitionRuntimeImpl((RuntimeMBean)j2EEApplicationRuntimeMBeanImpl, genericClassLoader);
            j2EEApplicationRuntimeMBeanImpl.setClassRedefinitionRuntime((ClassRedefinitionRuntimeMBean)classRedefinitionRuntimeImpl);
        }
        catch (ManagementException managementException) {
            throw new ClassRedefInitializationException(managementException.getMessage(), (Throwable)managementException);
        }
        catch (ClassCastException classCastException) {
            throw new ClassRedefInitializationException(classCastException.getMessage(), (Throwable)classCastException);
        }
    }
}

