/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.internal.AppClassLoaderManagerImpl;
import weblogic.application.internal.Flow;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.deploy.container.NonFatalDeploymentException;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.wl.ClassloaderStructureBean;
import weblogic.j2ee.descriptor.wl.ModuleRefBean;
import weblogic.management.DeploymentException;
import weblogic.utils.ErrorCollectionException;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.classloaders.MultiClassFinder;

public final class InitModulesFlow
extends BaseFlow
implements Flow {
    private static final AppClassLoaderManagerImpl appClassLoaderManager = (AppClassLoaderManagerImpl)AppClassLoaderManager.getAppClassLoaderManager();
    private static final boolean VERBOSE = false;
    private Set clstructLoaders = Collections.EMPTY_SET;
    private List missingModuleRefs = new ArrayList();

    public InitModulesFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    private Module findModuleWithUriInternal(Module[] moduleArray, String string) {
        for (int i = 0; i < moduleArray.length; ++i) {
            if (!string.equals(moduleArray[i].getId())) continue;
            return moduleArray[i];
        }
        return null;
    }

    private Module findWebModule(ApplicationBean applicationBean, Module[] moduleArray, String string) {
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray == null) {
            return null;
        }
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            if (moduleBeanArray[i].getWeb() == null || !moduleBeanArray[i].getWeb().getWebUri().equals(string)) continue;
            return this.findModuleWithUriInternal(moduleArray, moduleBeanArray[i].getWeb().getContextRoot());
        }
        return null;
    }

    private Module findModuleWithUri(Module[] moduleArray, String string) throws DeploymentException {
        Module module = this.findModuleWithUriInternal(moduleArray, string);
        if (module != null) {
            return module;
        }
        module = this.findWebModule(this.appCtx.getApplicationDD(), moduleArray, string);
        if (module != null) {
            return module;
        }
        Module[] moduleArray2 = this.appCtx.getApplicationModules();
        if (this.findModuleWithUriInternal(moduleArray2, string) == null && this.findWebModule(this.appCtx.getApplicationDD(), moduleArray2, string) == null && this.appCtx.getPartialRedeployURIs() == null) {
            throw new DeploymentException("classloader-structure element in weblogic-application.xml is referencing the module-uri " + string + " which does not exist in this application.");
        }
        return null;
    }

    private void initClassLoaderStructure(ClassloaderStructureBean classloaderStructureBean, GenericClassLoader genericClassLoader, Map map, Module[] moduleArray) throws DeploymentException {
        Module module;
        ModuleRefBean[] moduleRefBeanArray = classloaderStructureBean.getModuleRefs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < moduleRefBeanArray.length; ++i) {
            Object object;
            String string = moduleRefBeanArray[i].getModuleUri();
            module = this.findModuleWithUri(moduleArray, string);
            if (module != null) {
                if (this.missingModuleRefs.size() > 0 || arrayList.size() > 0) {
                    throw new NonFatalDeploymentException(" The following modules: " + (this.missingModuleRefs.size() > 0 ? this.missingModuleRefs.toString() : "") + (arrayList.size() > 0 ? ((Object)arrayList).toString() : "") + " which module uri " + string + " depends on are not initiated in this application.");
                }
                object = genericClassLoader.getAnnotation().getAnnotationString();
                if (object == null || "".equals(object)) {
                    genericClassLoader.setAnnotation(new Annotation(this.appCtx.getAppDeploymentMBean().getApplicationIdentifier(), string));
                }
                if (map.get(string) != null) {
                    throw new DeploymentException("The module-uri " + string + " is declared more than once in the classloader-structure." + "  Check your weblogic-application.xml");
                }
                module.initUsingLoader(this.appCtx, genericClassLoader, this.appCtx);
                appClassLoaderManager.addModuleLoader(genericClassLoader, module.getId());
                map.put(string, module);
                if (string.equals(module.getId())) continue;
                map.put(module.getId(), module);
                continue;
            }
            object = this.findModuleWithUri(this.appCtx.getApplicationModules(), string);
            if (object == null) {
                if (this.appCtx.getPartialRedeployURIs() == null) {
                    throw new DeploymentException("classloader-structure element in weblogic-application.xml is referencing the module-uri " + string + " which does not exist in this application.");
                }
                arrayList.add(string);
                continue;
            }
            GenericClassLoader genericClassLoader2 = appClassLoaderManager.findModuleLoader(this.appCtx.getAppDeploymentMBean().getApplicationIdentifier(), object.getId());
            if (genericClassLoader2 == null) continue;
            this.clstructLoaders.remove(genericClassLoader);
            genericClassLoader = genericClassLoader2;
        }
        ClassloaderStructureBean[] classloaderStructureBeanArray = classloaderStructureBean.getClassloaderStructures();
        if (classloaderStructureBeanArray == null || classloaderStructureBeanArray.length == 0) {
            return;
        }
        if (arrayList.size() > 0) {
            this.missingModuleRefs.add(arrayList);
        }
        for (int i = 0; i < classloaderStructureBeanArray.length; ++i) {
            module = new GenericClassLoader((ClassFinder)new MultiClassFinder(), (ClassLoader)genericClassLoader);
            if (this.clstructLoaders.size() == 0) {
                this.clstructLoaders = new LinkedHashSet();
            }
            this.clstructLoaders.add(module);
            this.initClassLoaderStructure(classloaderStructureBeanArray[i], (GenericClassLoader)module, map, moduleArray);
        }
        this.missingModuleRefs.remove(arrayList);
    }

    private void initRemainingModules(Map map, Module[] moduleArray) throws DeploymentException {
        for (int i = 0; i < moduleArray.length; ++i) {
            String string = moduleArray[i].getId();
            if (map.containsKey(string)) continue;
            this.initModule(moduleArray[i]);
            map.put(string, moduleArray[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModulesCLStructure(Module[] moduleArray) throws DeploymentException {
        HashMap hashMap = new HashMap(moduleArray.length);
        GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
        ClassloaderStructureBean classloaderStructureBean = this.appCtx.getWLApplicationDD().getClassloaderStructure();
        try {
            try {
                this.initClassLoaderStructure(classloaderStructureBean, genericClassLoader, hashMap, moduleArray);
                this.initRemainingModules(hashMap, moduleArray);
            }
            catch (Throwable throwable) {
                this.destroy(hashMap);
                this.throwAppException(throwable);
                Object var7_6 = null;
                this.missingModuleRefs.clear();
            }
            Object var7_5 = null;
            this.missingModuleRefs.clear();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.missingModuleRefs.clear();
            throw throwable;
        }
    }

    private void destroy(Map map) throws DeploymentException {
        Module[] moduleArray = new Module[map.size()];
        this.destroy(map.values().toArray(moduleArray), moduleArray.length);
    }

    private void initModule(Module module) throws ModuleException {
        GenericClassLoader genericClassLoader = module.init(this.appCtx, this.appCtx.getAppClassLoader(), this.appCtx);
        appClassLoaderManager.addModuleLoader(genericClassLoader, module.getId());
    }

    private void initModules(Module[] moduleArray) throws DeploymentException {
        GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
        for (int i = 0; i < moduleArray.length; ++i) {
            try {
                this.initModule(moduleArray[i]);
                continue;
            }
            catch (Throwable throwable) {
                try {
                    this.destroy(i);
                }
                catch (DeploymentException deploymentException) {
                    J2EELogger.logIgnoringUndeploymentError((Throwable)((Object)deploymentException));
                }
                this.throwAppException(throwable);
            }
        }
    }

    private boolean hasClassLoaderStructure() {
        return this.appCtx.getWLApplicationDD() != null && this.appCtx.getWLApplicationDD().getClassloaderStructure() != null;
    }

    public void prepare() throws DeploymentException {
        GenericClassLoader genericClassLoader;
        Module[] moduleArray = this.appCtx.getApplicationModules();
        if (this.appCtx.getStoppedModules() != null) {
            genericClassLoader = this.appCtx.getStoppedModules();
            ArrayList<Module> arrayList = new ArrayList<Module>();
            block0: for (int i = 0; i < moduleArray.length; ++i) {
                arrayList.add(moduleArray[i]);
                for (int j = 0; j < ((GenericClassLoader)genericClassLoader).length; ++j) {
                    if (!moduleArray[i].getId().equals(genericClassLoader[j])) continue;
                    arrayList.remove(moduleArray[i]);
                    continue block0;
                }
            }
            this.appCtx.setApplicationModules(arrayList.toArray(new Module[arrayList.size()]));
        }
        genericClassLoader = this.appCtx.getAppClassLoader();
        if (this.hasClassLoaderStructure()) {
            this.initModulesCLStructure(moduleArray);
        } else {
            this.initModules(moduleArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unprepare() throws DeploymentException {
        block5: {
            Module[] moduleArray = this.appCtx.getApplicationModules();
            try {
                this.destroy(moduleArray, moduleArray.length);
                Object var3_2 = null;
                if (this.clstructLoaders.size() <= 0) break block5;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.clstructLoaders.size() > 0) {
                    for (GenericClassLoader genericClassLoader : this.clstructLoaders) {
                        genericClassLoader.close();
                    }
                    this.clstructLoaders = Collections.EMPTY_SET;
                }
                throw throwable;
            }
            for (GenericClassLoader genericClassLoader : this.clstructLoaders) {
                genericClassLoader.close();
            }
            this.clstructLoaders = Collections.EMPTY_SET;
            {
            }
        }
    }

    private void destroy(int n) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getApplicationModules();
        this.destroy(moduleArray, n);
    }

    private void destroy(Module[] moduleArray, int n) throws DeploymentException {
        ErrorCollectionException errorCollectionException = null;
        for (int i = n - 1; i >= 0; --i) {
            try {
                moduleArray[i].destroy(this.appCtx);
                continue;
            }
            catch (Throwable throwable) {
                if (errorCollectionException == null) {
                    errorCollectionException = new ErrorCollectionException();
                }
                errorCollectionException.addError(throwable);
            }
        }
        if (errorCollectionException != null) {
            this.throwAppException((Throwable)errorCollectionException);
        }
    }

    public void start(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getStartingModules();
        if (this.hasClassLoaderStructure()) {
            this.initModulesCLStructure(moduleArray);
        } else {
            this.initModules(moduleArray);
        }
    }

    public void stop(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getStoppingModules();
        try {
            this.destroy(moduleArray, moduleArray.length);
        }
        catch (DeploymentException deploymentException) {
            J2EELogger.logIgnoringUndeploymentError((Throwable)((Object)deploymentException));
        }
    }
}

