/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.management.DeploymentException;

public final class InstrumentationFactoryFlow
extends BaseFlow {
    private static final String DIAGNOSTICS_DD = "META-INF/weblogic-diagnostics.xml";
    private static final String WLDF_MODULE_CLASSNAME = "weblogic.diagnostics.module.WLDFModule";

    public InstrumentationFactoryFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        if (this.appCtx.getStagingPath().endsWith(".xml")) {
            return;
        }
        try {
            String string = DIAGNOSTICS_DD;
            Class<?> clazz = Class.forName(WLDF_MODULE_CLASSNAME);
            Class[] classArray = new Class[]{String.class};
            Object[] objectArray = new Object[]{string};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Module module = (Module)constructor.newInstance(objectArray);
            Module[] moduleArray = this.appCtx.getApplicationModules();
            if (moduleArray == null) {
                moduleArray = new Module[]{};
            }
            Module[] moduleArray2 = new Module[moduleArray.length + 1];
            moduleArray2[0] = module;
            System.arraycopy(moduleArray, 0, moduleArray2, 1, moduleArray.length);
            this.appCtx.setApplicationModules(moduleArray2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DeploymentException(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new DeploymentException(noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new DeploymentException(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new DeploymentException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new DeploymentException(instantiationException);
        }
    }
}

