/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.security.Policy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.Flow;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.wl.ApplicationSecurityRoleAssignmentBean;
import weblogic.management.DeploymentException;
import weblogic.security.jacc.RoleMapper;
import weblogic.security.jacc.RoleMapperFactory;

public final class JACCPolicyConfigurationFlow
extends BaseFlow
implements Flow {
    public JACCPolicyConfigurationFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        if (!this.appCtx.useJACC()) {
            return;
        }
        this.handleRoleMapping();
    }

    public void activate() throws DeploymentException {
        if (!this.appCtx.useJACC()) {
            return;
        }
        PolicyConfiguration[] policyConfigurationArray = this.appCtx.getJACCPolicyConfigurations();
        this.linkPolicyConfigurations(policyConfigurationArray);
        this.commitPolicyConfigurations(policyConfigurationArray);
        this.refreshPolicy(policyConfigurationArray);
    }

    public void unprepare() {
        if (!this.appCtx.useJACC()) {
            return;
        }
        this.refreshPolicy(this.appCtx.getJACCPolicyConfigurations());
    }

    private void handleRoleMapping() throws DeploymentException {
        Map map = this.processRoleMappings();
        if (map != null) {
            RoleMapperFactory roleMapperFactory;
            try {
                roleMapperFactory = RoleMapperFactory.getRoleMapperFactory();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new DeploymentException(classNotFoundException);
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
            RoleMapper roleMapper = roleMapperFactory.getRoleMapper(this.appCtx.getApplicationId(), false);
            roleMapper.addAppRolesToPrincipalMap(map);
        }
    }

    private void refreshPolicy(PolicyConfiguration[] policyConfigurationArray) {
        if (policyConfigurationArray.length > 0) {
            Policy.getPolicy().refresh();
        }
    }

    private void linkPolicyConfigurations(PolicyConfiguration[] policyConfigurationArray) throws DeploymentException {
        if (policyConfigurationArray.length == 1) {
            return;
        }
        for (int i = policyConfigurationArray.length - 1; i > 0; --i) {
            try {
                policyConfigurationArray[i].linkConfiguration(policyConfigurationArray[i - 1]);
                continue;
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
        }
    }

    private void commitPolicyConfigurations(PolicyConfiguration[] policyConfigurationArray) throws DeploymentException {
        for (int i = 0; i < policyConfigurationArray.length; ++i) {
            try {
                policyConfigurationArray[i].commit();
                continue;
            }
            catch (PolicyContextException policyContextException) {
                throw new DeploymentException(policyContextException);
            }
        }
    }

    private String[] getSecurityRoleNames() {
        String[] stringArray = null;
        ApplicationBean applicationBean = this.appCtx.getApplicationDD();
        if (applicationBean == null) {
            return null;
        }
        SecurityRoleBean[] securityRoleBeanArray = applicationBean.getSecurityRoles();
        if (securityRoleBeanArray != null && securityRoleBeanArray.length != 0) {
            stringArray = new String[securityRoleBeanArray.length];
            for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                stringArray[i] = securityRoleBeanArray[i].getRoleName();
            }
        }
        return stringArray;
    }

    private Map processRoleMappings() throws DeploymentException {
        String[] stringArray = this.getSecurityRoleNames();
        Map map = this.getRoleToPrincipalsMapping();
        if (map == null) {
            return null;
        }
        if (stringArray == null || stringArray.length == 0) {
            stringArray = map.keySet().toArray(new String[map.size()]);
        }
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>(stringArray.length);
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = (String[])map.get(string);
            if (stringArray2 == null) {
                hashSet.add(string);
                continue;
            }
            hashMap.put(string, stringArray2);
        }
        if (!hashSet.isEmpty()) {
            throw new DeploymentException("Cannot find a role mapping for the following roles: " + hashSet);
        }
        return hashMap;
    }

    private Map getRoleToPrincipalsMapping() {
        if (this.appCtx.getWLApplicationDD() == null) {
            return null;
        }
        if (this.appCtx.getWLApplicationDD().getSecurity() == null) {
            return null;
        }
        ApplicationSecurityRoleAssignmentBean[] applicationSecurityRoleAssignmentBeanArray = this.appCtx.getWLApplicationDD().getSecurity().getSecurityRoleAssignments();
        if (applicationSecurityRoleAssignmentBeanArray == null || applicationSecurityRoleAssignmentBeanArray.length == 0) {
            return null;
        }
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        for (int i = 0; i < applicationSecurityRoleAssignmentBeanArray.length; ++i) {
            String[] stringArray = applicationSecurityRoleAssignmentBeanArray[i].getPrincipalNames();
            if (stringArray == null || stringArray.length <= 0) continue;
            hashMap.put(applicationSecurityRoleAssignmentBeanArray[i].getRoleName(), stringArray);
        }
        return hashMap;
    }
}

