/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.Module;
import weblogic.application.ModuleFactory;
import weblogic.application.ParentModule;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.ModulesCreator;
import weblogic.application.internal.flow.ScopedModuleDriver;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.management.DeploymentException;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JeeModulesCreator
implements ModulesCreator {
    private static final ApplicationFactoryManager afm = ApplicationFactoryManager.getApplicationFactoryManager();

    @Override
    public Module[] create(FlowContext flowContext) throws DeploymentException {
        ApplicationBean applicationBean = flowContext.getApplicationDD();
        if (applicationBean == null) {
            return new Module[0];
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        this.createModules(flowContext, applicationBean.getModules(), arrayList);
        return arrayList.toArray(new Module[arrayList.size()]);
    }

    private void createModules(FlowContext flowContext, ModuleBean[] moduleBeanArray, List<Module> list) throws DeploymentException {
        if (moduleBeanArray == null || moduleBeanArray.length == 0) {
            return;
        }
        for (ModuleBean moduleBean : moduleBeanArray) {
            Module module = this.createModuleFromFactories(flowContext, moduleBean);
            list.add(module);
        }
    }

    private Module createModuleFromFactories(FlowContext flowContext, ModuleBean moduleBean) throws DeploymentException {
        Iterator<ModuleFactory> iterator = afm.getModuleFactories();
        while (iterator.hasNext()) {
            ModuleFactory moduleFactory = iterator.next();
            Module module = moduleFactory.createModule(moduleBean);
            if (module == null) continue;
            return this.createAndAddScopedCustomModules(flowContext, module);
        }
        throw new DeploymentException("Unable to create module " + EarUtils.getModuleURI(moduleBean));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module createAndAddScopedCustomModules(FlowContext flowContext, Module module) throws DeploymentException {
        ScopedModuleDriver scopedModuleDriver;
        if (!(module instanceof ParentModule)) {
            return module;
        }
        String string = ((ParentModule)((Object)module)).getDescriptorURI();
        ModuleBean moduleBean = this.findStandardModuleDescriptor(flowContext, module.getId());
        if (moduleBean == null) {
            return module;
        }
        String string2 = EarUtils.reallyGetModuleURI(moduleBean);
        VirtualJarFile virtualJarFile = null;
        try {
            virtualJarFile = VirtualJarFactory.createVirtualJar((File[])flowContext.getEar().getModuleRoots(string2));
            scopedModuleDriver = new ScopedModuleDriver(module, flowContext, string2, virtualJarFile, string);
        }
        catch (IOException iOException) {
            Module module2;
            try {
                module2 = module;
            }
            catch (Throwable throwable) {
                IOUtils.forceClose(virtualJarFile);
                throw throwable;
            }
            IOUtils.forceClose(virtualJarFile);
            return module2;
        }
        IOUtils.forceClose(virtualJarFile);
        return scopedModuleDriver;
    }

    private ModuleBean findStandardModuleDescriptor(FlowContext flowContext, String string) {
        return this.findModuleDescriptor(flowContext.getApplicationDD().getModules(), string);
    }

    private ModuleBean findModuleDescriptor(ModuleBean[] moduleBeanArray, String string) {
        if (moduleBeanArray == null) {
            return null;
        }
        for (ModuleBean moduleBean : moduleBeanArray) {
            if (!EarUtils.getModuleURI(moduleBean).equals(string)) continue;
            return moduleBean;
        }
        return null;
    }
}

