/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.internal.flow.ModuleListenerInvoker;
import weblogic.application.internal.flow.NonTargetedModuleInvoker;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.TargetUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.WebBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.management.configuration.BasicDeploymentMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.SubDeploymentMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.provider.RuntimeAccess;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

abstract class ModuleFilterFlow
extends BaseFlow {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private final RuntimeAccess config = ManagementService.getRuntimeAccess(kernelId);
    private final ServerMBean server = this.config.getServer();

    ModuleFilterFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    private Map makeSubDeploymentMap(SubDeploymentMBean[] subDeploymentMBeanArray) {
        if (subDeploymentMBeanArray == null || subDeploymentMBeanArray.length == 0) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, SubDeploymentMBean> hashMap = new HashMap<String, SubDeploymentMBean>(subDeploymentMBeanArray.length);
        for (int i = 0; i < subDeploymentMBeanArray.length; ++i) {
            hashMap.put(EarUtils.toModuleId(this.appCtx, subDeploymentMBeanArray[i].getName()), subDeploymentMBeanArray[i]);
        }
        return hashMap;
    }

    private String findContextRoot(String string) {
        ApplicationBean applicationBean = this.appCtx.getApplicationDD();
        if (applicationBean == null) {
            return null;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray == null) {
            return null;
        }
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            WebBean webBean = moduleBeanArray[i].getWeb();
            if (webBean == null || !string.equals(webBean.getWebUri())) continue;
            return webBean.getContextRoot();
        }
        return null;
    }

    private SubDeploymentMBean findSubDeployment(Map map, String string) {
        WeblogicModuleBean[] weblogicModuleBeanArray;
        if (map.size() == 0) {
            return null;
        }
        SubDeploymentMBean subDeploymentMBean = (SubDeploymentMBean)map.get(string);
        if (subDeploymentMBean != null) {
            return subDeploymentMBean;
        }
        String string2 = this.findContextRoot(string);
        if (string2 != null && (subDeploymentMBean = (SubDeploymentMBean)map.get(string2)) != null) {
            return subDeploymentMBean;
        }
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean != null && (weblogicModuleBeanArray = weblogicApplicationBean.getModules()) != null) {
            for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
                if (!string.equals(weblogicModuleBeanArray[i].getPath())) continue;
                return (SubDeploymentMBean)map.get(weblogicModuleBeanArray[i].getName());
            }
        }
        return null;
    }

    protected Module[] createWrappedModules(List list) {
        BasicDeploymentMBean basicDeploymentMBean = this.appCtx.getBasicDeploymentMBean();
        TargetMBean targetMBean = TargetUtils.findLocalTarget(basicDeploymentMBean.getTargets(), this.server);
        Map map = this.makeSubDeploymentMap(basicDeploymentMBean.getSubDeployments());
        Module[] moduleArray = new Module[list.size()];
        Iterator iterator = list.iterator();
        for (int i = 0; i < moduleArray.length; ++i) {
            Module module = (Module)iterator.next();
            SubDeploymentMBean subDeploymentMBean = this.findSubDeployment(map, module.getId());
            if (this.hasNoTargets(subDeploymentMBean) && targetMBean != null) {
                moduleArray[i] = new ModuleListenerInvoker(module, targetMBean);
                continue;
            }
            if (subDeploymentMBean != null && subDeploymentMBean.getTargets().length > 0) {
                TargetMBean targetMBean2 = TargetUtils.findLocalTarget(subDeploymentMBean.getTargets(), this.server);
                if (targetMBean2 != null) {
                    moduleArray[i] = new ModuleListenerInvoker(module, targetMBean2);
                    continue;
                }
                moduleArray[i] = new NonTargetedModuleInvoker(module);
                continue;
            }
            moduleArray[i] = new NonTargetedModuleInvoker(module);
        }
        return moduleArray;
    }

    private boolean hasNoTargets(SubDeploymentMBean subDeploymentMBean) {
        return subDeploymentMBean == null || subDeploymentMBean.getTargets() == null || subDeploymentMBean.getTargets().length == 0;
    }
}

