/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.Iterator;
import java.util.Map;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContext;
import weblogic.application.DeploymentManager;
import weblogic.application.MergedDescriptorModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.ModuleListener;
import weblogic.application.ModuleListenerCtx;
import weblogic.application.ModuleListenerCtxImpl;
import weblogic.application.ModuleWrapper;
import weblogic.application.UpdateListener;
import weblogic.application.utils.ExceptionUtils;
import weblogic.descriptor.DescriptorBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;

public final class ModuleListenerInvoker
extends ModuleWrapper
implements Module,
MergedDescriptorModule {
    private final Module delegate;
    private final TargetMBean target;
    private ModuleListener.State state = ModuleListener.STATE_NEW;
    private ModuleListenerCtx ctx;
    private final DeploymentManager deploymentManager = DeploymentManager.getDeploymentManager();

    ModuleListenerInvoker(Module module, TargetMBean targetMBean) {
        this.delegate = module;
        this.target = targetMBean;
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.delegate.getClass().getName() + ")" + "(" + this.ctx.toString() + ")";
    }

    public Module getDelegate() {
        return this.delegate;
    }

    private void throwModuleException(Throwable throwable) throws ModuleException {
        ExceptionUtils.throwModuleException(throwable);
    }

    public String getId() {
        return this.delegate.getId();
    }

    public String getType() {
        return this.delegate.getType();
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return this.delegate.getComponentRuntimeMBeans();
    }

    public DescriptorBean[] getDescriptors() {
        return this.delegate.getDescriptors();
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.ctx = new ModuleListenerCtxImpl(applicationContext.getApplicationId(), this.getId(), this.target, this.getType());
        return this.delegate.init(applicationContext, genericClassLoader, registration);
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.ctx = new ModuleListenerCtxImpl(applicationContext.getApplicationId(), this.getId(), this.target, this.getType());
        this.delegate.initUsingLoader(applicationContext, genericClassLoader, registration);
    }

    public void prepare() throws ModuleException {
        try {
            this.begin(ModuleListener.STATE_PREPARED);
            this.delegate.prepare();
            this.end(ModuleListener.STATE_PREPARED);
            this.state = ModuleListener.STATE_PREPARED;
        }
        catch (Throwable throwable) {
            this.failed(ModuleListener.STATE_PREPARED);
            this.throwModuleException(throwable);
        }
    }

    public void activate() throws ModuleException {
        try {
            this.begin(ModuleListener.STATE_ADMIN);
            this.delegate.activate();
            this.end(ModuleListener.STATE_ADMIN);
            this.state = ModuleListener.STATE_ADMIN;
        }
        catch (Throwable throwable) {
            this.failed(ModuleListener.STATE_ADMIN);
            this.throwModuleException(throwable);
        }
    }

    public void start() throws ModuleException {
        this.delegate.start();
    }

    public void deactivate() throws ModuleException {
        try {
            this.begin(ModuleListener.STATE_PREPARED);
            this.delegate.deactivate();
            this.end(ModuleListener.STATE_PREPARED);
            this.state = ModuleListener.STATE_PREPARED;
        }
        catch (Throwable throwable) {
            this.failed(ModuleListener.STATE_PREPARED);
            this.throwModuleException(throwable);
        }
    }

    public void unprepare() throws ModuleException {
        try {
            this.begin(ModuleListener.STATE_NEW);
            this.delegate.unprepare();
            this.end(ModuleListener.STATE_NEW);
            this.state = ModuleListener.STATE_NEW;
        }
        catch (Throwable throwable) {
            this.failed(ModuleListener.STATE_NEW);
            this.throwModuleException(throwable);
        }
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        this.delegate.destroy(registration);
    }

    public void remove() throws ModuleException {
        this.delegate.remove();
    }

    public void adminToProduction() {
        try {
            this.begin(ModuleListener.STATE_ACTIVE);
            this.delegate.adminToProduction();
            this.end(ModuleListener.STATE_ACTIVE);
            this.state = ModuleListener.STATE_ACTIVE;
        }
        catch (RuntimeException runtimeException) {
            this.failed(ModuleListener.STATE_ACTIVE);
            throw runtimeException;
        }
        catch (Error error) {
            this.failed(ModuleListener.STATE_ACTIVE);
            throw error;
        }
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
        try {
            this.begin(ModuleListener.STATE_ADMIN);
            this.delegate.gracefulProductionToAdmin(adminModeCompletionBarrier);
            this.end(ModuleListener.STATE_ADMIN);
            this.state = ModuleListener.STATE_ADMIN;
        }
        catch (Throwable throwable) {
            this.failed(ModuleListener.STATE_ADMIN);
            this.throwModuleException(throwable);
        }
    }

    public void forceProductionToAdmin() throws ModuleException {
        try {
            this.begin(ModuleListener.STATE_ADMIN);
            this.delegate.forceProductionToAdmin();
            this.end(ModuleListener.STATE_ADMIN);
            this.state = ModuleListener.STATE_ADMIN;
        }
        catch (Throwable throwable) {
            this.failed(ModuleListener.STATE_ADMIN);
            this.throwModuleException(throwable);
        }
    }

    private void begin(ModuleListener.State state) {
        Iterator iterator = this.deploymentManager.getModuleListeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).beginTransition(this.ctx, this.state, state);
        }
    }

    private void end(ModuleListener.State state) {
        Iterator iterator = this.deploymentManager.getModuleListeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).endTransition(this.ctx, this.state, state);
        }
    }

    private void failed(ModuleListener.State state) {
        Iterator iterator = this.deploymentManager.getModuleListeners();
        while (iterator.hasNext()) {
            ((ModuleListener)iterator.next()).failedTransition(this.ctx, this.state, state);
        }
    }

    public Map getDescriptorMappings() {
        if (this.delegate instanceof MergedDescriptorModule) {
            return ((MergedDescriptorModule)((Object)this.delegate)).getDescriptorMappings();
        }
        return null;
    }

    public void handleMergedFinder(ClassFinder classFinder) {
        if (this.delegate instanceof MergedDescriptorModule) {
            ((MergedDescriptorModule)((Object)this.delegate)).handleMergedFinder(classFinder);
        }
    }
}

