/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.application.utils.ExceptionUtils;
import weblogic.application.utils.StateChange;
import weblogic.application.utils.StateChangeException;
import weblogic.application.utils.StateMachineDriver;
import weblogic.utils.Debug;
import weblogic.utils.StackTraceUtils;

final class ModuleStateDriver {
    private final StateMachineDriver driver = new StateMachineDriver();
    private final UpdateListener.Registration updateListenerRegistration;
    private static final StateChange prepareStateChange = new StateChange(){

        public String toString() {
            return "module_prepare";
        }

        public void next(Object object) throws Exception {
            ((Module)object).prepare();
        }

        public void previous(Object object) throws Exception {
            ((Module)object).unprepare();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            ModuleStateDriver.log("Ignoring unprepare errors " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };
    private static final StateChange activateStateChange = new StateChange(){

        public String toString() {
            return "module_activate";
        }

        public void next(Object object) throws Exception {
            ((Module)object).activate();
        }

        public void previous(Object object) throws Exception {
            ((Module)object).deactivate();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            ModuleStateDriver.log("Ignoring deactivate errors " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };
    private static final StateChange startStateChange = new StateChange(){

        public String toString() {
            return "module_start";
        }

        public void next(Object object) throws Exception {
            ((Module)object).start();
        }

        public void previous(Object object) {
        }

        public void logRollbackError(StateChangeException stateChangeException) {
        }
    };
    private static final StateChange removeStateChange = new StateChange(){

        public String toString() {
            return "module_remove";
        }

        public void next(Object object) throws Exception {
            throw new AssertionError((Object)"someone is transitioning up to remove!");
        }

        public void previous(Object object) throws Exception {
            ((Module)object).remove();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            ModuleStateDriver.log("Ignoring remove errors " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };
    private static final StateChange adminToProductionChange = new StateChange(){

        public String toString() {
            return "module_adminToProd";
        }

        public void next(Object object) throws Exception {
            ((Module)object).adminToProduction();
        }

        public void previous(Object object) throws Exception {
            ((Module)object).forceProductionToAdmin();
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            ModuleStateDriver.log("Ignoring errors while forcing to admin mode " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    };

    ModuleStateDriver(UpdateListener.Registration registration) {
        this.updateListenerRegistration = registration;
    }

    public void prepare(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.nextState(prepareStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void activate(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.nextState(activateStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void start(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.nextState(startStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void deactivate(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.previousState(activateStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void unprepare(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.previousState(prepareStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void remove(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.previousState(removeStateChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void destroy(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.previousState(new DestroyStateChange(this.updateListenerRegistration), moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void adminToProduction(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.nextState(adminToProductionChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void forceProductionToAdmin(Module[] moduleArray) throws ModuleException {
        try {
            this.driver.previousState(adminToProductionChange, moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier, Module[] moduleArray) throws ModuleException {
        try {
            this.driver.previousState(new GracefulProductionToAdminChange(adminModeCompletionBarrier), moduleArray);
        }
        catch (StateChangeException stateChangeException) {
            this.throwException(stateChangeException.getCause());
        }
    }

    private static void log(String string) {
        Debug.say((String)string);
    }

    private void throwException(Throwable throwable) throws ModuleException {
        ExceptionUtils.throwModuleException(throwable);
    }

    private static final class GracefulProductionToAdminChange
    implements StateChange {
        private final AdminModeCompletionBarrier barrier;

        public String toString() {
            return "module_gracefulProdToAdmin";
        }

        GracefulProductionToAdminChange(AdminModeCompletionBarrier adminModeCompletionBarrier) {
            this.barrier = adminModeCompletionBarrier;
        }

        public void next(Object object) throws Exception {
            throw new AssertionError((Object)"GracefulProductionToAdminChange.next");
        }

        public void previous(Object object) throws Exception {
            ((Module)object).gracefulProductionToAdmin(this.barrier);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            ModuleStateDriver.log("Ignoring errors while bringing to admin mode " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    }

    private static final class DestroyStateChange
    implements StateChange {
        private final UpdateListener.Registration reg;

        DestroyStateChange(UpdateListener.Registration registration) {
            this.reg = registration;
        }

        public String toString() {
            return "module_destroy";
        }

        public void next(Object object) throws Exception {
            throw new AssertionError((Object)"someone is transitioning up to destroy!");
        }

        public void previous(Object object) throws Exception {
            ((Module)object).destroy(this.reg);
        }

        public void logRollbackError(StateChangeException stateChangeException) {
            ModuleStateDriver.log("Ignoring destroy errors " + StackTraceUtils.throwable2StackTrace((Throwable)stateChangeException.getCause()));
        }
    }
}

