/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.ArrayList;
import java.util.List;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.Deployment;
import weblogic.application.DeploymentManager;
import weblogic.application.ModuleException;
import weblogic.application.UpdateListener;
import weblogic.application.utils.EarUtils;
import weblogic.deploy.internal.targetserver.DeploymentContextImpl;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.management.DeploymentException;

final class PartialRedeployUpdateListener
implements UpdateListener {
    private final DeploymentManager dm = DeploymentManager.getDeploymentManager();
    private final ApplicationContextInternal appCtx;
    private final List redeployModules = new ArrayList();
    private int activateCount;

    PartialRedeployUpdateListener(ApplicationContextInternal applicationContextInternal) {
        this.appCtx = applicationContextInternal;
    }

    public boolean acceptURI(String string) {
        ApplicationBean applicationBean = this.appCtx.getApplicationDD();
        if (applicationBean == null) {
            return false;
        }
        ModuleBean[] moduleBeanArray = applicationBean.getModules();
        if (moduleBeanArray == null) {
            return false;
        }
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            if (!string.equals(EarUtils.reallyGetModuleURI(moduleBeanArray[i]))) continue;
            return true;
        }
        return false;
    }

    public void prepareUpdate(String string) throws ModuleException {
        ModuleBean[] moduleBeanArray = this.appCtx.getApplicationDD().getModules();
        String string2 = string;
        for (int i = 0; i < moduleBeanArray.length; ++i) {
            if (moduleBeanArray[i].getWeb() == null || !moduleBeanArray[i].getWeb().getWebUri().equals(string)) continue;
            string2 = EarUtils.getContextRootName(moduleBeanArray[i]);
            break;
        }
        this.redeployModules.add(string2);
        this.activateCount = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateUpdate(String string) throws ModuleException {
        ++this.activateCount;
        if (this.activateCount < this.redeployModules.size()) {
            return;
        }
        try {
            String[] stringArray = this.redeployModules.toArray(new String[this.redeployModules.size()]);
            Deployment deployment = this.dm.findDeployment(this.appCtx.getApplicationId());
            try {
                DeploymentContextImpl deploymentContextImpl = new DeploymentContextImpl(this.appCtx.getDeploymentInitiator());
                deploymentContextImpl.setProposedDomain(this.appCtx.getProposedDomain());
                deploymentContextImpl.setUpdatedResourceURIs(stringArray);
                deployment.stop(deploymentContextImpl);
                deployment.start(deploymentContextImpl);
            }
            catch (DeploymentException deploymentException) {
                throw new ModuleException((Throwable)((Object)deploymentException));
            }
            Object var6_6 = null;
            this.redeployModules.clear();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.redeployModules.clear();
            throw throwable;
        }
    }

    public void rollbackUpdate(String string) {
        this.redeployModules.clear();
    }
}

