/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationAccess;
import weblogic.application.ApplicationContext;
import weblogic.application.MergedDescriptorModule;
import weblogic.application.Module;
import weblogic.application.ModuleException;
import weblogic.application.ModuleWrapper;
import weblogic.application.UpdateListener;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.CustomModuleHelper;
import weblogic.application.internal.flow.ModuleStateDriver;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.ExtensionDescriptorParser;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.descriptor.wl.WeblogicExtensionBean;
import weblogic.management.DeploymentException;
import weblogic.management.runtime.ComponentRuntimeMBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.utils.jars.VirtualJarFile;

public final class ScopedModuleDriver
extends ModuleWrapper
implements Module,
MergedDescriptorModule {
    private final Module module;
    private Module[] scopedModules = new Module[0];
    private Module[] allModules;
    private final ModuleStateDriver driver;
    private final String moduleUri;
    private DescriptorBean[] descriptors = null;
    private FlowContext appCtx;
    private WeblogicExtensionBean extDescriptor;
    private final String extensionLocationUri;
    private final ExtensionDescriptorParser extLoader;

    public ScopedModuleDriver(Module module, FlowContext flowContext, String string, VirtualJarFile virtualJarFile, String string2) throws ModuleException {
        if (module == null) {
            throw new IllegalArgumentException("module cannot be null");
        }
        if (this.scopedModules == null) {
            throw new IllegalArgumentException("scopedModules cannot be null");
        }
        this.module = module;
        this.appCtx = flowContext;
        this.driver = new ModuleStateDriver(flowContext);
        this.moduleUri = string;
        this.setScopedModules(new Module[0]);
        this.extensionLocationUri = string2;
        this.extLoader = this.createModuleExtensionLoader(virtualJarFile);
        try {
            this.extDescriptor = this.extLoader.getWlExtensionDescriptor();
        }
        catch (IOException iOException) {
            throw new ModuleException(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new ModuleException(xMLStreamException);
        }
    }

    private void setScopedModules(Module[] moduleArray) {
        this.scopedModules = moduleArray;
        this.allModules = new Module[moduleArray.length + 1];
        this.allModules[0] = this.module;
        if (moduleArray.length > 0) {
            System.arraycopy(moduleArray, 0, this.allModules, 1, moduleArray.length);
        }
    }

    public Module getDelegate() {
        return this.module;
    }

    public String getId() {
        return this.module.getId();
    }

    public String getType() {
        return this.module.getType();
    }

    public ComponentRuntimeMBean[] getComponentRuntimeMBeans() {
        return this.module.getComponentRuntimeMBeans();
    }

    public synchronized DescriptorBean[] getDescriptors() {
        if (this.descriptors != null) {
            return this.descriptors;
        }
        ArrayList<WeblogicExtensionBean> arrayList = new ArrayList<WeblogicExtensionBean>();
        this.addDescriptors(this.module, arrayList);
        arrayList.add(this.extDescriptor);
        for (int i = 0; i < this.scopedModules.length; ++i) {
            this.addDescriptors(this.scopedModules[i], arrayList);
        }
        this.descriptors = arrayList.toArray(new DescriptorBean[arrayList.size()]);
        return this.descriptors;
    }

    private void addDescriptors(Module module, List list) {
        DescriptorBean[] descriptorBeanArray = this.module.getDescriptors();
        for (int i = 0; i < descriptorBeanArray.length; ++i) {
            list.add(descriptorBeanArray[i]);
        }
    }

    public GenericClassLoader init(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        GenericClassLoader genericClassLoader2 = this.module.init(applicationContext, genericClassLoader, registration);
        this.initScopedModules(applicationContext, genericClassLoader2, registration);
        return genericClassLoader2;
    }

    public void initUsingLoader(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        this.module.initUsingLoader(applicationContext, genericClassLoader, registration);
        this.initScopedModules(applicationContext, genericClassLoader, registration);
    }

    private void initScopedModules(ApplicationContext applicationContext, GenericClassLoader genericClassLoader, UpdateListener.Registration registration) throws ModuleException {
        for (int i = 0; i < this.scopedModules.length; ++i) {
            this.scopedModules[i].init(applicationContext, genericClassLoader, registration);
        }
    }

    public void prepare() throws ModuleException {
        this.module.prepare();
        this.findAndInitScopedCustomModules();
        this.prepareScopedModules();
    }

    private void prepareScopedModules() throws ModuleException {
        this.driver.prepare(this.scopedModules);
    }

    public void activate() throws ModuleException {
        this.driver.activate(this.allModules);
    }

    public void start() throws ModuleException {
        this.driver.start(this.allModules);
    }

    public void deactivate() throws ModuleException {
        this.driver.deactivate(this.allModules);
    }

    public void unprepare() throws ModuleException {
        this.driver.unprepare(this.allModules);
    }

    public void destroy(UpdateListener.Registration registration) throws ModuleException {
        this.driver.destroy(this.allModules);
    }

    public void remove() throws ModuleException {
        this.driver.remove(this.allModules);
    }

    public void adminToProduction() {
        try {
            this.driver.adminToProduction(this.allModules);
        }
        catch (ModuleException moduleException) {
            if (moduleException.getCause() != null && moduleException.getCause() instanceof RuntimeException) {
                throw (RuntimeException)moduleException.getCause();
            }
            throw new RuntimeException((Throwable)((Object)moduleException));
        }
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws ModuleException {
        this.driver.gracefulProductionToAdmin(adminModeCompletionBarrier, this.allModules);
    }

    public void forceProductionToAdmin() throws ModuleException {
        this.driver.forceProductionToAdmin(this.allModules);
    }

    private void findAndInitScopedCustomModules() throws ModuleException {
        block5: {
            GenericClassLoader genericClassLoader = ApplicationAccess.getApplicationAccess().findModuleLoader(this.appCtx.getApplicationId(), this.module.getId());
            try {
                this.extLoader.mergeWlExtensionDescriptorsFromLibraries(this.appCtx);
                WeblogicExtensionBean weblogicExtensionBean = this.extLoader.getWlExtensionDescriptor();
                if (weblogicExtensionBean == null) break block5;
                try {
                    Module[] moduleArray = CustomModuleHelper.createScopedCustomModules(this.module, this.moduleUri, weblogicExtensionBean, genericClassLoader);
                    this.setScopedModules(moduleArray);
                    this.initScopedModules(this.appCtx, genericClassLoader, this.appCtx);
                }
                catch (DeploymentException deploymentException) {
                    throw new ModuleException((Throwable)((Object)deploymentException));
                }
            }
            catch (IOException iOException) {
                throw new ModuleException(iOException);
            }
            catch (XMLStreamException xMLStreamException) {
                throw new ModuleException(xMLStreamException);
            }
        }
    }

    private ExtensionDescriptorParser createModuleExtensionLoader(VirtualJarFile virtualJarFile) throws ModuleException {
        return new ExtensionDescriptorParser(virtualJarFile, EarUtils.getConfigDir(this.appCtx), this.appCtx.getAppDeploymentMBean().getDeploymentPlanDescriptor(), this.module.getId(), this.extensionLocationUri + "/" + "weblogic-extension.xml");
    }

    public Map getDescriptorMappings() {
        HashMap<String, DescriptorBean> hashMap = null;
        for (int i = 0; i < this.allModules.length; ++i) {
            MergedDescriptorModule mergedDescriptorModule;
            if (this.allModules[i] == this || !(this.allModules[i] instanceof MergedDescriptorModule) || (mergedDescriptorModule = (MergedDescriptorModule)((Object)this.allModules[i])).getDescriptorMappings() == null) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, DescriptorBean>();
            }
            hashMap.putAll(mergedDescriptorModule.getDescriptorMappings());
        }
        return hashMap;
    }

    public void handleMergedFinder(ClassFinder classFinder) {
        for (int i = 0; i < this.allModules.length; ++i) {
            if (this.allModules[i] == this || !(this.allModules[i] instanceof MergedDescriptorModule)) continue;
            ((MergedDescriptorModule)((Object)this.allModules[i])).handleMergedFinder(classFinder);
        }
    }
}

