/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.SecurityRole;
import weblogic.application.internal.Flow;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.descriptor.BeanUpdateEvent;
import weblogic.descriptor.BeanUpdateListener;
import weblogic.descriptor.BeanUpdateRejectedException;
import weblogic.descriptor.DescriptorBean;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.SecurityRoleBean;
import weblogic.j2ee.descriptor.wl.ApplicationSecurityRoleAssignmentBean;
import weblogic.j2ee.descriptor.wl.SecurityBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.ApplicationResource;
import weblogic.security.service.DeployHandleCreationException;
import weblogic.security.service.PrivilegedActions;
import weblogic.security.service.ResourceBase;
import weblogic.security.service.RoleCreationException;
import weblogic.security.service.RoleManager;
import weblogic.security.service.RoleManagerDeployHandle;
import weblogic.security.service.RoleRemovalException;
import weblogic.security.service.SecurityApplicationInfo;
import weblogic.security.service.SecurityApplicationInfoImpl;
import weblogic.security.service.SecurityService;
import weblogic.security.service.SecurityServiceManager;
import weblogic.security.spi.ApplicationInfo;
import weblogic.security.spi.Resource;

public final class SecurityRoleFlow
extends BaseFlow
implements Flow {
    private static final boolean DEBUG = false;
    private RoleManagerDeployHandle handle;
    private RoleManager roleManager = null;
    private static AuthenticatedSubject kernelId = null;
    private SecurityApplicationInfo secInfo = null;
    private String realmName = null;
    private static final SecurityRole NOOP_MAPPING = new SecurityRole(null);

    public SecurityRoleFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepare() throws DeploymentException {
        if (this.appCtx.useJACC()) {
            return;
        }
        this.realmName = this.getDefaultRealmName();
        this.appCtx.setApplicationSecurityRealmName(this.realmName);
        if (this.roleManager == null) {
            this.initSecurityService();
        }
        this.secInfo = new SecurityApplicationInfoImpl(this.appCtx.getAppDeploymentMBean(), ApplicationInfo.ComponentType.APPLICATION, this.appCtx.getApplicationName());
        try {
            this.handle = this.roleManager.startDeployRoles(this.secInfo);
            try {
                this.deployRoles();
            }
            finally {
                this.roleManager.endDeployRoles(this.handle);
            }
        }
        catch (DeployHandleCreationException deployHandleCreationException) {
            throw new DeploymentException(deployHandleCreationException);
        }
        catch (RoleCreationException roleCreationException) {
            throw new DeploymentException(roleCreationException);
        }
    }

    public void unprepare() throws DeploymentException {
        if (this.appCtx.useJACC()) {
            return;
        }
        this.undeployRoles();
    }

    private void initSecurityService() {
        this.roleManager = (RoleManager)SecurityServiceManager.getSecurityService((AuthenticatedSubject)this.getKernelID(), (String)this.realmName, (SecurityService.ServiceType)SecurityService.ServiceType.ROLE);
    }

    private String[] getSecurityRoleNames() {
        SecurityRoleBean[] securityRoleBeanArray;
        String[] stringArray = null;
        ApplicationBean applicationBean = this.appCtx.getApplicationDD();
        SecurityRoleBean[] securityRoleBeanArray2 = securityRoleBeanArray = applicationBean != null ? applicationBean.getSecurityRoles() : null;
        if (securityRoleBeanArray != null && securityRoleBeanArray.length != 0) {
            stringArray = new String[securityRoleBeanArray.length];
            for (int i = 0; i < securityRoleBeanArray.length; ++i) {
                stringArray[i] = securityRoleBeanArray[i].getRoleName();
            }
        }
        return stringArray;
    }

    private Map getSecurityRoleAssignments() {
        HashMap<String, SecurityRole> hashMap = new HashMap<String, SecurityRole>();
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean == null) {
            return hashMap;
        }
        SecurityBean securityBean = weblogicApplicationBean.getSecurity();
        if (securityBean == null) {
            return hashMap;
        }
        ApplicationSecurityRoleAssignmentBean[] applicationSecurityRoleAssignmentBeanArray = securityBean.getSecurityRoleAssignments();
        if (applicationSecurityRoleAssignmentBeanArray != null) {
            for (int i = 0; i < applicationSecurityRoleAssignmentBeanArray.length; ++i) {
                String string = applicationSecurityRoleAssignmentBeanArray[i].getRoleName();
                String[] stringArray = applicationSecurityRoleAssignmentBeanArray[i].getPrincipalNames();
                if (applicationSecurityRoleAssignmentBeanArray[i].getExternallyDefined() != null) {
                    hashMap.put(string, new SecurityRole());
                    continue;
                }
                hashMap.put(string, new SecurityRole(stringArray));
            }
        }
        return hashMap;
    }

    private AuthenticatedSubject getKernelID() {
        if (kernelId == null) {
            kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        }
        return kernelId;
    }

    private String getDefaultRealmName() {
        String string;
        SecurityBean securityBean;
        String string2 = "weblogicDEFAULT";
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean != null && (securityBean = weblogicApplicationBean.getSecurity()) != null && (string = securityBean.getRealmName()) != null) {
            string2 = string;
        }
        return string2;
    }

    private boolean isCompatibilitySecMode() {
        return SecurityServiceManager.getRoleMappingBehavior((String)this.realmName, (SecurityApplicationInfo)this.secInfo) == 0;
    }

    private boolean isApplicationSecMode() {
        return SecurityServiceManager.getRoleMappingBehavior((String)this.realmName, (SecurityApplicationInfo)this.secInfo) == 1;
    }

    private boolean isExternallyDefinedSecMode() {
        return SecurityServiceManager.getRoleMappingBehavior((String)this.realmName, (SecurityApplicationInfo)this.secInfo) == 2;
    }

    private void deployRoles() throws DeploymentException {
        String[] stringArray = this.getSecurityRoleNames();
        Map map = this.getSecurityRoleAssignments();
        if (stringArray == null && map != null) {
            stringArray = map.keySet().toArray(new String[map.size()]);
        }
        if (stringArray == null) {
            return;
        }
        if (!this.isCompatibilitySecMode()) {
            this.appCtx.setAppLevelRoleMappings(map);
        }
        ApplicationResource applicationResource = new ApplicationResource(this.appCtx.getApplicationId());
        if (this.isCompatibilitySecMode()) {
            this.deployRolesAllowEmptyRoleMapping((ResourceBase)applicationResource, stringArray, map);
        } else if (this.isApplicationSecMode()) {
            this.deployRolesAllowEmptyRoleMapping((ResourceBase)applicationResource, stringArray, map);
        } else if (this.isExternallyDefinedSecMode()) {
            this.deployRolesNoEmptyRoleMapping((ResourceBase)applicationResource, stringArray, map);
        } else {
            throw new AssertionError((Object)"Unknown security mode");
        }
    }

    private void deployRolesAllowEmptyRoleMapping(ResourceBase resourceBase, String[] stringArray, Map map) throws DeploymentException {
        this.deployRoles(resourceBase, stringArray, map, true);
    }

    private void deployRolesNoEmptyRoleMapping(ResourceBase resourceBase, String[] stringArray, Map map) throws DeploymentException {
        this.deployRoles(resourceBase, stringArray, map, false);
    }

    private void deployRoles(ResourceBase resourceBase, String[] stringArray, Map map, boolean bl) throws DeploymentException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            SecurityRole securityRole = (SecurityRole)map.get(stringArray[i]);
            if (securityRole == null) {
                securityRole = NOOP_MAPPING;
            }
            if (securityRole.isExternallyDefined()) continue;
            String[] stringArray2 = securityRole.getPrincipalNames();
            if (stringArray2 == null) {
                if (!bl) continue;
                stringArray2 = new String[]{};
            }
            this.deployRole(resourceBase, stringArray[i], stringArray2);
        }
    }

    private void deployRole(ResourceBase resourceBase, String string, String[] stringArray) throws DeploymentException {
        try {
            this.roleManager.deployRole(this.handle, (Resource)resourceBase, string, stringArray);
        }
        catch (RoleCreationException roleCreationException) {
            Loggable loggable = J2EELogger.logCouldNotDeployRoleLoggable((String)string, (String)ApplicationVersionUtils.getDisplayName(this.appCtx.getApplicationId()), (Throwable)roleCreationException);
            loggable.log();
            throw new DeploymentException(loggable.getMessage());
        }
    }

    private void undeployRoles() throws DeploymentException {
        try {
            this.roleManager.undeployAllRoles(this.handle);
        }
        catch (RoleRemovalException roleRemovalException) {
            throw new DeploymentException(roleRemovalException);
        }
    }

    private static class SecurityRoleAssignmentUpdateListener
    implements BeanUpdateListener {
        private final ApplicationContextInternal appCtx;
        private final SecurityApplicationInfo secInfo;
        private final RoleManager roleManager;

        private SecurityRoleAssignmentUpdateListener(ApplicationContextInternal applicationContextInternal, SecurityApplicationInfo securityApplicationInfo, RoleManager roleManager) {
            this.appCtx = applicationContextInternal;
            this.secInfo = securityApplicationInfo;
            this.roleManager = roleManager;
        }

        static void registerListeners(ApplicationContextInternal applicationContextInternal, SecurityApplicationInfo securityApplicationInfo, RoleManager roleManager) {
            WeblogicApplicationBean weblogicApplicationBean = applicationContextInternal.getWLApplicationDD();
            if (weblogicApplicationBean == null) {
                return;
            }
            SecurityBean securityBean = weblogicApplicationBean.getSecurity();
            if (securityBean == null) {
                return;
            }
            ApplicationSecurityRoleAssignmentBean[] applicationSecurityRoleAssignmentBeanArray = securityBean.getSecurityRoleAssignments();
            if (applicationSecurityRoleAssignmentBeanArray == null || applicationSecurityRoleAssignmentBeanArray.length == 0) {
                return;
            }
            for (int i = 0; i < applicationSecurityRoleAssignmentBeanArray.length; ++i) {
                ((DescriptorBean)applicationSecurityRoleAssignmentBeanArray[i]).addBeanUpdateListener((BeanUpdateListener)new SecurityRoleAssignmentUpdateListener(applicationContextInternal, securityApplicationInfo, roleManager));
            }
        }

        public void prepareUpdate(BeanUpdateEvent beanUpdateEvent) throws BeanUpdateRejectedException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void activateUpdate(BeanUpdateEvent beanUpdateEvent) {
            ApplicationSecurityRoleAssignmentBean applicationSecurityRoleAssignmentBean = (ApplicationSecurityRoleAssignmentBean)beanUpdateEvent.getProposedBean();
            try {
                RoleManagerDeployHandle roleManagerDeployHandle = this.roleManager.startDeployRoles(this.secInfo);
                try {
                    ApplicationResource applicationResource = new ApplicationResource(this.appCtx.getApplicationId());
                    this.roleManager.deployRole(roleManagerDeployHandle, (Resource)applicationResource, applicationSecurityRoleAssignmentBean.getRoleName(), applicationSecurityRoleAssignmentBean.getPrincipalNames());
                }
                finally {
                    this.roleManager.endDeployRoles(roleManagerDeployHandle);
                }
            }
            catch (Exception exception) {
                Loggable loggable = J2EELogger.logCouldNotDeployRoleLoggable((String)applicationSecurityRoleAssignmentBean.getRoleName(), (String)ApplicationVersionUtils.getDisplayName(this.appCtx.getApplicationId()), (Throwable)exception);
                loggable.log();
            }
        }

        public void rollbackUpdate(BeanUpdateEvent beanUpdateEvent) {
        }
    }
}

