/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.io.File;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.SingleModuleFileManager;
import weblogic.application.internal.AppClassLoaderManagerImpl;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.AppFileOverrideUtils;
import weblogic.management.DeploymentException;
import weblogic.spring.monitoring.instrumentation.SpringInstrumentationUtils;
import weblogic.utils.classloaders.Annotation;
import weblogic.utils.classloaders.GenericClassLoader;

public final class SingleModuleClassLoaderFlow
extends BaseFlow {
    private static final AppClassLoaderManagerImpl appClassLoaderManager = (AppClassLoaderManagerImpl)AppClassLoaderManager.getAppClassLoaderManager();

    public SingleModuleClassLoaderFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
        AppFileOverrideUtils.addFinderIfRequired(this.appCtx.getAppDeploymentMBean(), genericClassLoader);
        genericClassLoader.setAnnotation(new Annotation(this.appCtx.getBasicDeploymentMBean().getName()));
        File file = new File(this.appCtx.getStagingPath());
        this.appCtx.setApplicationPaths(new File[]{file});
        this.appCtx.setApplicationFileManager(new SingleModuleFileManager(file));
        SpringInstrumentationUtils.addSpringInstrumentor((GenericClassLoader)genericClassLoader);
    }

    public void unprepare() {
        appClassLoaderManager.removeApplicationLoader(this.appCtx.getApplicationId());
        GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
        genericClassLoader.close();
    }
}

