/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.net.URL;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.cluster.singleton.SingletonService;
import weblogic.cluster.singleton.SingletonServicesManager;
import weblogic.j2ee.J2EELogger;
import weblogic.j2ee.descriptor.wl.SingletonServiceBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.logging.Loggable;
import weblogic.management.DeploymentException;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.GenericClassLoader;
import weblogic.work.InheritableThreadContext;

public final class SingletonServicesFlow
extends BaseFlow {
    private SingletonServicesManager manager = SingletonServicesManager.getInstance();
    private SingletonServiceBean[] serviceBeans;
    private SingletonService[] services;
    private InheritableThreadContext context;

    public SingletonServicesFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        WeblogicApplicationBean weblogicApplicationBean = this.appCtx.getWLApplicationDD();
        if (weblogicApplicationBean == null) {
            return;
        }
        this.serviceBeans = weblogicApplicationBean.getSingletonServices();
        if (this.serviceBeans == null || this.serviceBeans.length == 0) {
            return;
        }
        this.services = new SingletonService[this.serviceBeans.length];
        for (int i = 0; i < this.serviceBeans.length; ++i) {
            String string = this.serviceBeans[i].getClassName();
            String string2 = this.serviceBeans[i].getSingletonUri();
            GenericClassLoader genericClassLoader = this.appCtx.getAppClassLoader();
            if (string2 != null) {
                this.addListenerJarToLoader(genericClassLoader, string2);
            }
            this.services[i] = SingletonServicesManager.constructSingletonService(string, (ClassLoader)genericClassLoader);
            this.context = InheritableThreadContext.getContext();
        }
    }

    public void activate() throws DeploymentException {
        if (this.serviceBeans == null) {
            return;
        }
        String string = null;
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        if (appDeploymentMBean != null) {
            string = ApplicationVersionUtils.getVersionId(appDeploymentMBean.getApplicationIdentifier());
        }
        for (int i = 0; i < this.serviceBeans.length; ++i) {
            try {
                this.manager.addConfiguredService(SingletonServicesManager.Util.getAppscopedSingletonServiceName(this.serviceBeans[i].getName(), string), this.services[i], this.context);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new DeploymentException(illegalArgumentException);
            }
        }
    }

    public void deactivate() throws DeploymentException {
        if (this.serviceBeans == null) {
            return;
        }
        String string = null;
        AppDeploymentMBean appDeploymentMBean = this.appCtx.getAppDeploymentMBean();
        if (appDeploymentMBean != null) {
            string = ApplicationVersionUtils.getVersionId(appDeploymentMBean.getApplicationIdentifier());
        }
        for (int i = 0; i < this.serviceBeans.length; ++i) {
            this.manager.remove(SingletonServicesManager.Util.getAppscopedSingletonServiceName(this.serviceBeans[i].getName(), string));
        }
    }

    public void unprepare() throws DeploymentException {
    }

    private void addListenerJarToLoader(GenericClassLoader genericClassLoader, String string) throws DeploymentException {
        URL uRL = genericClassLoader.getResource(this.appCtx.getApplicationId() + "#" + string);
        if (uRL == null) {
            Loggable loggable = J2EELogger.logUnabletoFindSingletonJarLoggable((String)this.appCtx.getApplicationId(), (String)string);
            throw new DeploymentException(loggable.getMessage());
        }
        genericClassLoader.addClassFinder((ClassFinder)new ClasspathClassFinder2(uRL.getFile()));
    }
}

