/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import weblogic.application.ApplicationContextInternal;
import weblogic.application.Module;
import weblogic.application.internal.Flow;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.internal.flow.ModuleStateDriver;
import weblogic.management.DeploymentException;
import weblogic.utils.ErrorCollectionException;

public final class StartModulesFlow
extends BaseFlow
implements Flow {
    private final ModuleStateDriver driver;

    public StartModulesFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
        this.driver = new ModuleStateDriver(this.appCtx);
    }

    public void activate() throws DeploymentException {
        this.driver.start(this.appCtx.getApplicationModules());
    }

    public void start(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getStartingModules();
        try {
            this.driver.start(moduleArray);
        }
        catch (Throwable throwable) {
            ErrorCollectionException errorCollectionException = new ErrorCollectionException(throwable);
            try {
                this.driver.deactivate(moduleArray);
            }
            catch (Throwable throwable2) {
                errorCollectionException.add(throwable2);
            }
            try {
                this.driver.unprepare(moduleArray);
            }
            catch (Throwable throwable3) {
                errorCollectionException.add(throwable3);
            }
            try {
                this.driver.destroy(moduleArray);
            }
            catch (Throwable throwable4) {
                errorCollectionException.add(throwable4);
            }
            this.throwAppException((Throwable)errorCollectionException);
        }
    }
}

