/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.Map;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.EarUtils;
import weblogic.ejb.spi.ScrubbedCache;

public final class TailEJBCacheFlow
extends BaseFlow {
    public TailEJBCacheFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void activate() {
        this.startEJBCache();
    }

    public void deactivate() {
        this.stopEJBCache();
    }

    private void startEJBCache() {
        Map map;
        if (EarUtils.isDebugOn()) {
            EarUtils.debug(" starting cache scrubbers for app: " + this.appCtx.getApplicationId());
        }
        if ((map = this.appCtx.getEJBCacheMap()) != null) {
            for (Object v : map.values()) {
                if (!(v instanceof ScrubbedCache)) continue;
                ((ScrubbedCache)v).startScrubber();
            }
        }
    }

    private void stopEJBCache() {
        Map map;
        if (EarUtils.isDebugOn()) {
            EarUtils.debug(" stopping cache scrubbers for app: " + this.appCtx.getApplicationId());
        }
        if ((map = this.appCtx.getEJBCacheMap()) != null) {
            for (Object v : map.values()) {
                if (!(v instanceof ScrubbedCache)) continue;
                ((ScrubbedCache)v).stopScrubber();
            }
        }
    }
}

