/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.Set;
import weblogic.application.AppClassLoaderManager;
import weblogic.application.Module;
import weblogic.application.ModuleManager;
import weblogic.application.ModuleNotFoundException;
import weblogic.application.internal.AppClassLoaderManagerImpl;
import weblogic.application.internal.Flow;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.EarUtils;
import weblogic.deploy.container.DeploymentContext;
import weblogic.kernel.Kernel;
import weblogic.management.DeploymentException;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public final class TailModuleRedeployFlow
extends BaseFlow
implements Flow {
    private static final AuthenticatedSubject KERNEL_ID = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final boolean PRODUCTION_MODE_ENABLED = !Kernel.isServer() || ManagementService.getRuntimeAccess(KERNEL_ID).getDomain().isProductionModeEnabled();
    private final ModuleManager moduleManager;

    public TailModuleRedeployFlow(FlowContext flowContext) {
        super(flowContext);
        this.moduleManager = flowContext.getModuleManager();
    }

    public void start(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getStartingModules();
        this.appCtx.setStartingModules(new Module[0]);
        Module[] moduleArray2 = this.appCtx.getApplicationModules();
        Module[] moduleArray3 = new Module[moduleArray2.length + moduleArray.length];
        System.arraycopy(moduleArray2, 0, moduleArray3, 0, moduleArray2.length);
        System.arraycopy(moduleArray, 0, moduleArray3, moduleArray2.length, moduleArray.length);
        this.appCtx.setApplicationModules(moduleArray3);
    }

    public void stop(String[] stringArray) throws DeploymentException {
        Module[] moduleArray = this.appCtx.getApplicationModules();
        ArrayList<Module> arrayList = new ArrayList<Module>();
        block0: for (int i = 0; i < moduleArray.length; ++i) {
            for (int j = 0; j < stringArray.length; ++j) {
                if (!moduleArray[i].getId().equals(stringArray[j])) continue;
                arrayList.add(moduleArray[i]);
                continue block0;
            }
        }
        this.appCtx.setStoppingModules(arrayList.toArray(new Module[arrayList.size()]));
    }

    public void validateRedeploy(DeploymentContext deploymentContext) throws DeploymentException {
        String[] stringArray = deploymentContext.getUpdatedResourceURIs();
        if (!deploymentContext.isAppStaged()) {
            this.validateModuleUris(stringArray);
        }
        this.validateClassLoaderStructure(stringArray);
    }

    private String[] getOldUris(String[] stringArray) {
        ModuleManager moduleManager = this.appCtx.getModuleManager();
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            String string = (String)listIterator.next();
            if (!moduleManager.isNewUri(string)) continue;
            listIterator.remove();
        }
        return arrayList.toArray(new String[0]);
    }

    private void validateModuleUris(String[] stringArray) throws ModuleNotFoundException {
        ModuleManager moduleManager = this.appCtx.getModuleManager();
        if (!moduleManager.validateModuleIds(stringArray) && !moduleManager.validateModuleIds(stringArray = EarUtils.toModuleIds(this.appCtx, stringArray))) {
            throw new ModuleNotFoundException(moduleManager.getInvalidModuleIds(stringArray));
        }
    }

    private void validateClassLoaderStructure(String[] stringArray) throws DeploymentException {
        String[] stringArray2 = this.getOldUris(stringArray);
        AppClassLoaderManagerImpl appClassLoaderManagerImpl = (AppClassLoaderManagerImpl)AppClassLoaderManager.getAppClassLoaderManager();
        if (!PRODUCTION_MODE_ENABLED) {
            Set<String> set = appClassLoaderManagerImpl.updatePartialDeploySet(this.appCtx, stringArray2);
            if (set.size() > stringArray2.length) {
                set.addAll(Arrays.asList(stringArray));
                this.appCtx.setPartialRedeployURIs(set.toArray(new String[set.size()]));
            }
        } else {
            appClassLoaderManagerImpl.checkPartialRedeploy(this.appCtx, stringArray2);
        }
    }
}

