/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.Module;
import weblogic.application.WebLogicApplicationModuleFactory;
import weblogic.application.WeblogicModuleFactory;
import weblogic.application.internal.FlowContext;
import weblogic.application.internal.flow.ModulesCreator;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.management.DeploymentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebLogicModulesCreator
implements ModulesCreator {
    private static final ApplicationFactoryManager afm = ApplicationFactoryManager.getApplicationFactoryManager();

    @Override
    public Module[] create(FlowContext flowContext) throws DeploymentException {
        WeblogicApplicationBean weblogicApplicationBean = flowContext.getWLApplicationDD();
        if (weblogicApplicationBean == null) {
            return new Module[0];
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        this.createModules(weblogicApplicationBean.getModules(), arrayList);
        this.createOldStyleWLDDModules(weblogicApplicationBean, arrayList);
        return arrayList.toArray(new Module[arrayList.size()]);
    }

    private void createModules(WeblogicModuleBean[] weblogicModuleBeanArray, List<Module> list) throws DeploymentException {
        if (weblogicModuleBeanArray == null || weblogicModuleBeanArray.length == 0) {
            return;
        }
        for (WeblogicModuleBean weblogicModuleBean : weblogicModuleBeanArray) {
            Module module = this.createModuleFromFactories(weblogicModuleBean);
            list.add(module);
        }
    }

    private Module createModuleFromFactories(WeblogicModuleBean weblogicModuleBean) throws DeploymentException {
        Iterator<WeblogicModuleFactory> iterator = afm.getWeblogicModuleFactories();
        while (iterator.hasNext()) {
            WeblogicModuleFactory weblogicModuleFactory = iterator.next();
            Module module = weblogicModuleFactory.createModule(weblogicModuleBean);
            if (module == null) continue;
            return module;
        }
        throw new DeploymentException("Unable to find module for " + weblogicModuleBean.getClass().getName());
    }

    private void createOldStyleWLDDModules(WeblogicApplicationBean weblogicApplicationBean, List<Module> list) throws DeploymentException {
        Iterator<WebLogicApplicationModuleFactory> iterator = afm.getWLAppModuleFactories();
        while (iterator.hasNext()) {
            WebLogicApplicationModuleFactory webLogicApplicationModuleFactory = iterator.next();
            Module[] moduleArray = webLogicApplicationModuleFactory.createModule(weblogicApplicationBean);
            if (moduleArray == null || moduleArray.length <= 0) continue;
            list.addAll(Arrays.asList(moduleArray));
        }
    }
}

