/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.flow;

import java.util.Iterator;
import weblogic.application.AdminModeCompletionBarrier;
import weblogic.application.ApplicationContextInternal;
import weblogic.application.internal.flow.BaseFlow;
import weblogic.application.utils.ApplicationVersionUtils;
import weblogic.management.DeploymentException;
import weblogic.utils.Debug;
import weblogic.utils.DebugCategory;
import weblogic.work.RMIGracePeriodManager;
import weblogic.work.ShutdownCallback;
import weblogic.work.WorkManagerCollection;
import weblogic.work.WorkManagerLogger;
import weblogic.work.WorkManagerService;

public final class WorkManagerFlow
extends BaseFlow {
    private static final DebugCategory debugWMFlow = Debug.getCategory((String)"weblogic.workmanagerflow");

    public WorkManagerFlow(ApplicationContextInternal applicationContextInternal) {
        super(applicationContextInternal);
    }

    public void prepare() throws DeploymentException {
        try {
            if (debugWMFlow.isEnabled()) {
                WorkManagerLogger.logDebug((String)("-- wmflow -- calling prepare on - " + this.appCtx.getApplicationId()));
            }
            WorkManagerCollection workManagerCollection = this.appCtx.getWorkManagerCollection();
            workManagerCollection.setApplicationRuntime(this.appCtx.getRuntime());
            workManagerCollection.initialize(this.appCtx.getWLApplicationDD());
        }
        catch (DeploymentException deploymentException) {
            throw new DeploymentException((Throwable)((Object)deploymentException));
        }
    }

    public void activate() throws DeploymentException {
        if (debugWMFlow.isEnabled()) {
            WorkManagerLogger.logDebug((String)("-- wmflow -- calling activate on - " + this.appCtx.getApplicationId()));
        }
        WorkManagerCollection workManagerCollection = this.appCtx.getWorkManagerCollection();
        workManagerCollection.setState(1);
        for (WorkManagerService workManagerService : workManagerCollection) {
            if (debugWMFlow.isEnabled()) {
                WorkManagerLogger.logDebug((String)("-- wmflow -- starting - " + workManagerService.toString()));
            }
            workManagerService.start();
        }
    }

    public void adminToProduction() throws DeploymentException {
        WorkManagerCollection workManagerCollection;
        if (debugWMFlow.isEnabled()) {
            WorkManagerLogger.logDebug((String)("-- wmflow -- calling adminToProduction on - " + this.appCtx.getApplicationId()));
        }
        if ((workManagerCollection = this.appCtx.getWorkManagerCollection()).getState() != 1) {
            workManagerCollection.setState(1);
            for (WorkManagerService workManagerService : workManagerCollection) {
                if (!workManagerService.isShutdown()) continue;
                if (debugWMFlow.isEnabled()) {
                    WorkManagerLogger.logDebug((String)("-- wmflow -- starting - " + workManagerService.toString()));
                }
                workManagerService.start();
            }
        }
    }

    public void forceProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
        if (debugWMFlow.isEnabled()) {
            WorkManagerLogger.logDebug((String)("-- wmflow -- calling forceProductionToAdmin on - " + this.appCtx.getApplicationId()));
        }
        WorkManagerCollection workManagerCollection = this.appCtx.getWorkManagerCollection();
        workManagerCollection.setState(0);
        for (WorkManagerService workManagerService : workManagerCollection) {
            if (debugWMFlow.isEnabled()) {
                WorkManagerLogger.logDebug((String)("-- wmflow -- shutdown no callback - " + workManagerService.toString()));
            }
            workManagerService.shutdown(adminModeCompletionBarrier.registerWMShutdown());
        }
    }

    public void gracefulProductionToAdmin(AdminModeCompletionBarrier adminModeCompletionBarrier) throws DeploymentException {
        if (debugWMFlow.isEnabled()) {
            WorkManagerLogger.logDebug((String)("-- wmflow -- calling gracefulProductionToAdmin on - " + this.appCtx.getApplicationId()));
        }
        WorkManagerCollection workManagerCollection = this.appCtx.getWorkManagerCollection();
        workManagerCollection.setState(0);
        Iterator iterator = workManagerCollection.iterator();
        int n = ApplicationVersionUtils.getRMIGracePeriodAppCtxParam(this.appCtx);
        RMIGracePeriodManager rMIGracePeriodManager = null;
        if (n > 0) {
            rMIGracePeriodManager = new RMIGracePeriodManager(workManagerCollection, n);
        }
        while (iterator.hasNext()) {
            WorkManagerService workManagerService = (WorkManagerService)iterator.next();
            if (debugWMFlow.isEnabled()) {
                WorkManagerLogger.logDebug((String)("-- wmflow -- shutdown with callback - " + workManagerService.toString()));
            }
            if (n > 0) {
                workManagerService.startRMIGracePeriod(rMIGracePeriodManager);
            }
            workManagerService.shutdown(adminModeCompletionBarrier.registerWMShutdown());
        }
    }

    public void deactivate() throws DeploymentException {
        WorkManagerCollection workManagerCollection;
        if (debugWMFlow.isEnabled()) {
            WorkManagerLogger.logDebug((String)("-- wmflow -- calling deactivate on - " + this.appCtx.getApplicationId()));
        }
        if ((workManagerCollection = this.appCtx.getWorkManagerCollection()).getState() != 0) {
            workManagerCollection.setState(0);
            ShutdownCallback shutdownCallback = new ShutdownCallback(){

                public void completed() {
                }
            };
            for (WorkManagerService workManagerService : workManagerCollection) {
                if (debugWMFlow.isEnabled()) {
                    WorkManagerLogger.logDebug((String)("-- wmflow -- shutdown with noop callback - " + workManagerService.toString()));
                }
                workManagerService.shutdown(shutdownCallback);
            }
        }
    }

    public void unprepare() throws DeploymentException {
        WorkManagerCollection workManagerCollection = this.appCtx.getWorkManagerCollection();
        if (workManagerCollection != null) {
            workManagerCollection.close();
        }
    }
}

