/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.jar.Attributes;
import weblogic.application.Type;
import weblogic.application.internal.library.util.DeweyDecimal;
import weblogic.application.library.IllegalSpecVersionTypeException;
import weblogic.application.library.LibraryConstants;
import weblogic.application.utils.LibraryUtils;
import weblogic.management.configuration.LibraryMBean;

public class BasicLibraryData
implements Serializable {
    private static final String NOT_SET = "<not-set>";
    private final String name;
    private final DeweyDecimal specVersion;
    private final String implVersion;
    private Type type;

    public BasicLibraryData(Attributes attributes) throws IllegalSpecVersionTypeException {
        this(BasicLibraryData.getName(attributes), BasicLibraryData.getSpecVersion(attributes), BasicLibraryData.getImplVersion(attributes));
    }

    public BasicLibraryData(LibraryMBean libraryMBean) throws IllegalSpecVersionTypeException {
        this(BasicLibraryData.getName(libraryMBean), BasicLibraryData.getSpecVersion(libraryMBean), BasicLibraryData.getImplVersion(libraryMBean));
    }

    public BasicLibraryData(String string, String string2, String string3) throws IllegalSpecVersionTypeException {
        this(string, BasicLibraryData.parseSpec(string2), string3);
    }

    public BasicLibraryData(String string, String string2, String string3, Type type) throws IllegalSpecVersionTypeException {
        this(string, BasicLibraryData.parseSpec(string2), string3, type);
    }

    protected BasicLibraryData(String string, DeweyDecimal deweyDecimal, String string2) {
        this(string, deweyDecimal, string2, null);
    }

    public BasicLibraryData(String string, DeweyDecimal deweyDecimal, String string2, Type type) {
        this.name = string;
        this.specVersion = deweyDecimal;
        this.implVersion = string2;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public DeweyDecimal getSpecificationVersion() {
        return this.specVersion;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return LibraryUtils.toString(this);
    }

    public BasicLibraryData importData(BasicLibraryData basicLibraryData) {
        String string = this.getName() != null ? this.getName() : basicLibraryData.getName();
        DeweyDecimal deweyDecimal = this.getSpecificationVersion() != null ? this.getSpecificationVersion() : basicLibraryData.getSpecificationVersion();
        String string2 = this.getImplementationVersion() != null ? this.getImplementationVersion() : basicLibraryData.getImplementationVersion();
        Type type = this.getType() != null ? this.getType() : basicLibraryData.getType();
        return new BasicLibraryData(string, deweyDecimal, string2, type);
    }

    public Collection verifyDataConsistency(BasicLibraryData basicLibraryData) {
        ArrayList arrayList = new ArrayList(3);
        this.verifyDataConsistency(basicLibraryData, arrayList);
        return arrayList;
    }

    private void verifyDataConsistency(BasicLibraryData basicLibraryData, Collection collection) {
        this.checkForMismatch(LibraryConstants.LIBRARY_NAME, this.getName(), basicLibraryData.getName(), collection);
        this.checkForMismatch(LibraryConstants.SPEC_VERSION_NAME, LibraryUtils.nullOrString(this.getSpecificationVersion()), LibraryUtils.nullOrString(basicLibraryData.getSpecificationVersion()), collection);
        this.checkForMismatch(LibraryConstants.IMPL_VERSION_NAME, this.getImplementationVersion(), basicLibraryData.getImplementationVersion(), collection);
    }

    private void checkForMismatch(String string, String string2, String string3, Collection collection) {
        String string4;
        String string5 = string2 == null ? NOT_SET : string2;
        String string6 = string4 = string3 == null ? NOT_SET : string3;
        if (!string5.equals(string4)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string).append(": ").append(string5).append(" vs. ").append(string4);
            collection.add(stringBuffer.toString());
        }
    }

    private static String getName(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        String string = attributes.getValue(LibraryConstants.LIBRARY_NAME);
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    private static String getName(LibraryMBean libraryMBean) {
        return LibraryUtils.getName(libraryMBean);
    }

    private static DeweyDecimal getSpecVersion(Attributes attributes) throws IllegalSpecVersionTypeException {
        if (attributes == null) {
            return null;
        }
        return BasicLibraryData.parseSpec(attributes.getValue(LibraryConstants.SPEC_VERSION_NAME));
    }

    private static DeweyDecimal getSpecVersion(LibraryMBean libraryMBean) throws IllegalSpecVersionTypeException {
        return BasicLibraryData.parseSpec(LibraryUtils.getSpecVersion(libraryMBean));
    }

    private static String getImplVersion(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        String string = attributes.getValue(LibraryConstants.IMPL_VERSION_NAME);
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    private static String getImplVersion(LibraryMBean libraryMBean) {
        return LibraryUtils.getImplVersion(libraryMBean);
    }

    private static DeweyDecimal parseSpec(String string) throws IllegalSpecVersionTypeException {
        if (string == null) {
            return null;
        }
        String string2 = string.trim();
        DeweyDecimal deweyDecimal = null;
        try {
            deweyDecimal = new DeweyDecimal(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalSpecVersionTypeException(string2);
        }
        return deweyDecimal;
    }
}

