/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import weblogic.application.ApplicationDescriptor;
import weblogic.application.Type;
import weblogic.application.io.DescriptorFinder;
import weblogic.application.io.Ear;
import weblogic.application.io.ManifestFinder;
import weblogic.application.library.ApplicationLibrary;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryContext;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LibraryReference;
import weblogic.application.utils.EarUtils;
import weblogic.application.utils.IOUtils;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.j2ee.descriptor.ApplicationBean;
import weblogic.j2ee.descriptor.ModuleBean;
import weblogic.j2ee.descriptor.wl.CustomModuleBean;
import weblogic.j2ee.descriptor.wl.PreferApplicationPackagesBean;
import weblogic.j2ee.descriptor.wl.WeblogicApplicationBean;
import weblogic.j2ee.descriptor.wl.WeblogicModuleBean;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.ClasspathClassFinder2;
import weblogic.utils.classloaders.MultiClassFinder;
import weblogic.utils.jars.VirtualJarFactory;
import weblogic.utils.jars.VirtualJarFile;

public class EarLibraryDefinition
extends LibraryDefinition
implements Library,
ApplicationLibrary {
    private final File extractDir;
    private Ear ear = null;
    private VirtualJarFile vjf = null;
    private ApplicationDescriptor parser = null;
    private J2EELibraryReference[] libraryRefs = null;
    private boolean inited = false;
    private List filters = Collections.EMPTY_LIST;

    public EarLibraryDefinition(LibraryData libraryData, File file) {
        super(libraryData, Type.EAR);
        this.extractDir = file;
    }

    public void init() throws LibraryProcessingException {
        if (this.inited) {
            return;
        }
        if (this.getAutoRef().length > 0) {
            throw new LibraryProcessingException("ear libraries may not be auto-ref");
        }
        try {
            if (this.isArchive(this.getLocation())) {
                this.ear = new Ear(this.getName(), this.extractDir, this.getLocation());
                this.setLocation(this.extractDir);
                if (LibraryUtils.isDebugOn()) {
                    LibraryUtils.debug("Extracted ear into:" + this.extractDir.getAbsolutePath());
                }
            } else {
                this.ear = new Ear(this.getName(), this.extractDir, new File[]{this.getLocation()});
            }
            this.initDescriptors();
        }
        catch (IOException iOException) {
            throw new LibraryProcessingException(iOException);
        }
        this.inited = true;
    }

    private void initDescriptors() throws IOException, LibraryProcessingException {
        try {
            this.vjf = VirtualJarFactory.createVirtualJar((File)this.getLocation());
            this.parser = new ApplicationDescriptor(this.vjf);
            WeblogicApplicationBean weblogicApplicationBean = this.parser.getWeblogicApplicationDescriptor();
            if (weblogicApplicationBean != null) {
                this.libraryRefs = LibraryLoggingUtils.initLibRefs(weblogicApplicationBean.getLibraryRefs());
                PreferApplicationPackagesBean preferApplicationPackagesBean = weblogicApplicationBean.getPreferApplicationPackages();
                if (preferApplicationPackagesBean != null) {
                    String[] stringArray = preferApplicationPackagesBean.getPackageNames();
                    this.filters = EarLibraryDefinition.validatePackages(stringArray);
                }
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new LibraryProcessingException(xMLStreamException);
        }
    }

    private boolean isArchive(File file) {
        return file.isFile();
    }

    public void cleanup() {
        IOUtils.forceClose(this.vjf);
        if (this.ear != null) {
            this.ear.getClassFinder().close();
        }
    }

    public void remove() {
        if (this.ear != null) {
            if (LibraryUtils.isDebugOn()) {
                LibraryUtils.debug("Calling remove on ear library");
            }
            this.ear.remove();
        }
    }

    public void importLibrary(J2EELibraryReference j2EELibraryReference, LibraryContext libraryContext, MultiClassFinder multiClassFinder) throws LibraryProcessingException {
        Object object;
        Object object2;
        LibraryLoggingUtils.checkNoContextRootSet(j2EELibraryReference, Type.EAR);
        ModuleBean[] moduleBeanArray = null;
        WeblogicModuleBean[] weblogicModuleBeanArray = null;
        CustomModuleBean[] customModuleBeanArray = null;
        try {
            ApplicationBean applicationBean = this.parser.getApplicationDescriptor();
            if (applicationBean != null) {
                moduleBeanArray = applicationBean.getModules();
            }
            if ((object2 = this.parser.getWeblogicApplicationDescriptor()) != null) {
                weblogicModuleBeanArray = object2.getModules();
            }
            if ((object = this.parser.getWeblogicExtensionDescriptor()) != null) {
                customModuleBeanArray = object.getCustomModules();
            }
            ApplicationDescriptor applicationDescriptor = libraryContext.getApplicationDescriptor();
            LibraryLoggingUtils.mergeDescriptors(applicationDescriptor, this.vjf);
            libraryContext.notifyDescriptorUpdate();
        }
        catch (IOException iOException) {
            LibraryLoggingUtils.errorMerging(iOException);
        }
        catch (XMLStreamException xMLStreamException) {
            LibraryLoggingUtils.errorMerging(xMLStreamException);
        }
        if (moduleBeanArray != null) {
            for (int i = 0; i < moduleBeanArray.length; ++i) {
                try {
                    libraryContext.registerLink(new File(this.getLocation(), EarUtils.reallyGetModuleURI(moduleBeanArray[i])));
                    continue;
                }
                catch (IOException iOException) {
                    throw new LibraryProcessingException(iOException);
                }
            }
        }
        if (weblogicModuleBeanArray != null) {
            for (int i = 0; i < weblogicModuleBeanArray.length; ++i) {
                try {
                    object2 = weblogicModuleBeanArray[i].getPath();
                    object = new File(this.getLocation(), (String)object2);
                    if (((File)object).isDirectory()) {
                        libraryContext.registerLink(((File)object).getName(), (File)object);
                        continue;
                    }
                    libraryContext.registerLink((String)object2, (File)object);
                    continue;
                }
                catch (IOException iOException) {
                    throw new LibraryProcessingException(iOException);
                }
            }
        }
        if (customModuleBeanArray != null) {
            for (int i = 0; i < customModuleBeanArray.length; ++i) {
                try {
                    object2 = new File(this.getLocation(), customModuleBeanArray[i].getUri());
                    if (((File)object2).exists()) {
                        libraryContext.registerLink((File)object2);
                        continue;
                    }
                    libraryContext.registerLink(customModuleBeanArray[i].getUri(), this.getLocation());
                    continue;
                }
                catch (IOException iOException) {
                    throw new LibraryProcessingException(iOException);
                }
            }
        }
        multiClassFinder.addFinderFirst((ClassFinder)new DescriptorFinder(libraryContext.getRefappUri(), (ClassFinder)new ClasspathClassFinder2(this.getLocation().getAbsolutePath())));
        multiClassFinder.addFinderFirst(this.getClassFinder());
    }

    public LibraryReference[] getLibraryReferences() {
        return this.libraryRefs;
    }

    private ClassFinder getClassFinder() {
        MultiClassFinder multiClassFinder = new MultiClassFinder();
        multiClassFinder.addFinder((ClassFinder)new ManifestFinder.ExtensionListFinder(this.getLocation()));
        multiClassFinder.addFinder((ClassFinder)new ClasspathClassFinder2(this.ear.getClassFinder().getClassPath()));
        return multiClassFinder;
    }

    public List getFilters() {
        return this.filters;
    }

    private static List validatePackages(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        List<String> list = Arrays.asList(stringArray);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            if (string.endsWith("*")) {
                string = string.substring(0, string.length() - 1);
            }
            if (!string.endsWith(".")) {
                string = string + ".";
            }
            arrayList.add(string);
        }
        return arrayList;
    }
}

