/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.io.File;
import weblogic.application.internal.library.EarLibraryDefinition;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryFactory;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.EarUtils;
import weblogic.j2ee.J2EELogger;

public class EarLibraryFactory
implements LibraryFactory {
    public LibraryDefinition createLibrary(LibraryData libraryData, File file) throws LibraryProcessingException {
        if (EarUtils.isEar(libraryData.getLocation())) {
            if (EarUtils.isSplitDir(libraryData.getLocation())) {
                throw new LoggableLibraryProcessingException(J2EELogger.logSplitDirNotSupportedForLibrariesLoggable((String)libraryData.getLocation().getAbsolutePath()));
            }
            return new EarLibraryDefinition(libraryData, file);
        }
        return null;
    }
}

