/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.io.IOException;
import weblogic.application.Type;
import weblogic.application.library.ApplicationLibrary;
import weblogic.application.library.J2EELibraryReference;
import weblogic.application.library.Library;
import weblogic.application.library.LibraryContext;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.utils.classloaders.ClassFinder;
import weblogic.utils.classloaders.JarClassFinder;
import weblogic.utils.classloaders.MultiClassFinder;

public class JarLibraryDefinition
extends LibraryDefinition
implements Library,
ApplicationLibrary {
    public JarLibraryDefinition(LibraryData libraryData) {
        super(libraryData, Type.JAR);
    }

    public void importLibrary(J2EELibraryReference j2EELibraryReference, LibraryContext libraryContext, MultiClassFinder multiClassFinder) throws LibraryProcessingException {
        LibraryLoggingUtils.checkNoContextRootSet(j2EELibraryReference, Type.JAR);
        try {
            multiClassFinder.addFinderFirst(this.getClassFinder());
        }
        catch (IOException iOException) {
            throw new LibraryProcessingException(iOException);
        }
    }

    private ClassFinder getClassFinder() throws IOException {
        return new JarClassFinder(this.getLocation());
    }

    public void init() throws LibraryProcessingException {
        if (this.getAutoRef().length > 0) {
            throw new LibraryProcessingException("jar libraries may not be auto-ref");
        }
    }
}

