/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import weblogic.application.ApplicationContext;
import weblogic.application.ApplicationContextFactory;
import weblogic.application.Deployment;
import weblogic.application.RedeployInfo;
import weblogic.application.internal.RedeployInfoImpl;
import weblogic.application.internal.library.LibraryRegistry;
import weblogic.application.internal.library.LibraryRuntimeMBeanImpl;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryDeploymentException;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.LibraryUtils;
import weblogic.deploy.container.DeploymentContext;
import weblogic.management.ManagementException;
import weblogic.management.configuration.LibraryMBean;

public class LibraryDeployment
implements Deployment {
    private static final LibraryRegistry libraryRegistry = LibraryRegistry.getRegistry();
    private final LibraryDefinition def;
    private final ApplicationContext appCtx;
    private final LibraryMBean mbean;

    public LibraryDeployment(LibraryDefinition libraryDefinition, LibraryMBean libraryMBean) {
        this.def = libraryDefinition;
        this.mbean = libraryMBean;
        this.appCtx = ApplicationContextFactory.getApplicationContextFactory().newApplicationContext(libraryMBean.getName());
    }

    public void prepare(DeploymentContext deploymentContext) throws LibraryDeploymentException {
        try {
            LibraryLoggingUtils.initLibraryDefinition(this.def);
            this.registerLibrary();
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new LibraryDeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
        this.initRuntime();
    }

    private void initRuntime() throws LibraryDeploymentException {
        LibraryRuntimeMBeanImpl libraryRuntimeMBeanImpl = null;
        try {
            libraryRuntimeMBeanImpl = new LibraryRuntimeMBeanImpl(this.def.getLibData(), this.mbean.getApplicationIdentifier(), this.mbean.getAppMBean().getComponents());
        }
        catch (ManagementException managementException) {
            throw new LibraryDeploymentException(managementException);
        }
        this.def.setRuntime(libraryRuntimeMBeanImpl);
    }

    private void registerLibrary() throws LoggableLibraryProcessingException {
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Registering: " + this.def + "(" + this.def.getType() + ")");
        }
        LibraryLoggingUtils.registerLibrary(this.def, true);
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Registry has: " + libraryRegistry.toString());
        }
    }

    public void unprepare(DeploymentContext deploymentContext) throws LibraryDeploymentException {
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("unprepare");
        }
        this.unregisterLibrary();
    }

    public void remove(DeploymentContext deploymentContext) throws LibraryDeploymentException {
        try {
            LibraryLoggingUtils.errorRemoveLibrary(this.def);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new LibraryDeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
    }

    public void unregisterLibrary() throws LibraryDeploymentException {
        try {
            this.def.getRuntimeImpl().unregister();
        }
        catch (ManagementException managementException) {
            throw new LibraryDeploymentException(managementException);
        }
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("Removing from registry...: " + this.def);
        }
        libraryRegistry.remove(this.def);
        if (LibraryUtils.isDebugOn()) {
            LibraryUtils.debug("...Now registry has: " + libraryRegistry.toString());
        }
    }

    public void gracefulProductionToAdmin(DeploymentContext deploymentContext) {
        Deployment.AdminModeCallback adminModeCallback = null;
        if (deploymentContext != null) {
            adminModeCallback = deploymentContext.getAdminModeCallback();
        }
        if (adminModeCallback != null) {
            adminModeCallback.completed();
        }
    }

    public void forceProductionToAdmin(DeploymentContext deploymentContext) {
        Deployment.AdminModeCallback adminModeCallback = null;
        if (deploymentContext != null) {
            adminModeCallback = deploymentContext.getAdminModeCallback();
        }
        if (adminModeCallback != null) {
            adminModeCallback.completed();
        }
    }

    public RedeployInfo validateRedeploy(DeploymentContext deploymentContext) {
        return new RedeployInfoImpl();
    }

    public void activate(DeploymentContext deploymentContext) {
    }

    public void deactivate(DeploymentContext deploymentContext) {
    }

    public void prepareUpdate(DeploymentContext deploymentContext) {
    }

    public void activateUpdate(DeploymentContext deploymentContext) {
    }

    public void rollbackUpdate(DeploymentContext deploymentContext) {
    }

    public void adminToProduction(DeploymentContext deploymentContext) {
    }

    public void stop(DeploymentContext deploymentContext) {
    }

    public void start(DeploymentContext deploymentContext) {
    }

    public boolean deregisterCallback(int n) {
        return false;
    }

    public ApplicationContext getApplicationContext() {
        return this.appCtx;
    }
}

