/*
 * Decompiled with CFR 0.152.
 */
package weblogic.application.internal.library;

import java.io.File;
import java.security.AccessController;
import java.util.jar.Attributes;
import weblogic.application.ApplicationFactoryManager;
import weblogic.application.Deployment;
import weblogic.application.DeploymentFactory;
import weblogic.application.internal.library.LibraryDeployment;
import weblogic.application.library.LibraryData;
import weblogic.application.library.LibraryDefinition;
import weblogic.application.library.LibraryDeploymentException;
import weblogic.application.library.LoggableLibraryProcessingException;
import weblogic.application.utils.LibraryLoggingUtils;
import weblogic.application.utils.PathUtils;
import weblogic.management.configuration.AppDeploymentMBean;
import weblogic.management.configuration.LibraryMBean;
import weblogic.management.configuration.SystemResourceMBean;
import weblogic.management.provider.ManagementService;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;

public class LibraryDeploymentFactory
implements DeploymentFactory {
    private static final AuthenticatedSubject kernelId = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
    private static final String serverName = ManagementService.getRuntimeAccess(kernelId).getServerName();
    private static final ApplicationFactoryManager afm = ApplicationFactoryManager.getApplicationFactoryManager();

    public Deployment createDeployment(AppDeploymentMBean appDeploymentMBean, File file) throws LibraryDeploymentException {
        if (!(appDeploymentMBean instanceof LibraryMBean)) {
            return null;
        }
        LibraryMBean libraryMBean = (LibraryMBean)appDeploymentMBean;
        LibraryData libraryData = this.getLibData(libraryMBean, file);
        String string = PathUtils.generateTempPath(serverName, libraryData.getName(), libraryData.getSpecificationVersion() + libraryData.getImplementationVersion());
        File file2 = PathUtils.getAppTempDir(string, libraryMBean.isInternalApp());
        LibraryDefinition libraryDefinition = null;
        try {
            libraryDefinition = LibraryLoggingUtils.getLibraryDefinition(libraryData, file2, afm.getLibraryFactories());
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new LibraryDeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
        return this.createDeployment(libraryDefinition, libraryMBean);
    }

    private Deployment createDeployment(LibraryDefinition libraryDefinition, LibraryMBean libraryMBean) {
        return new LibraryDeployment(libraryDefinition, libraryMBean);
    }

    public Deployment createDeployment(SystemResourceMBean systemResourceMBean, File file) {
        return null;
    }

    private LibraryData getLibData(LibraryMBean libraryMBean, File file) throws LibraryDeploymentException {
        LibraryData libraryData = null;
        try {
            libraryData = LibraryLoggingUtils.initLibraryData(libraryMBean, file);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new LibraryDeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
        LibraryData libraryData2 = null;
        Attributes attributes = libraryData.getAttributes();
        try {
            libraryData2 = LibraryLoggingUtils.initLibraryData(file, attributes);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new LibraryDeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
        libraryData2 = libraryData2.importData(libraryData);
        try {
            LibraryLoggingUtils.handleLibraryInfoMismatch(libraryData2, libraryData);
        }
        catch (LoggableLibraryProcessingException loggableLibraryProcessingException) {
            throw new LibraryDeploymentException(loggableLibraryProcessingException.getLoggable().getMessage());
        }
        return libraryData;
    }
}

